/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/bmc/ctmconvert/uc4/SyncObjectsHandler;", "", "job", "Lcom/bmc/ctmconvert/uc4/UC4Job;", "<init>", "(Lcom/bmc/ctmconvert/uc4/UC4Job;)V", "process", "", "handleSyncObject", "issueWarningMessageOfMissingSync", "syncRowName", "", "handleQuantitativeResource", "syncRules", "Lcom/bmc/ctmconvert/common/AttrHolderList;", "syncRowAction", "handleControlResource", "syncStates", "jobHasSyncObjects", "", "getMultiSyncAttributesById", "syncObj", "Lcom/bmc/ctmconvert/uc4/UC4Objects/UC4Object;", "id", "getMaxValueSetForTheAction", "", "action", "getMaxValueCheck", "syncHaveShareStatus", "states", "getMultiAttributeSyncId", "Scheduler-UC4"})
public final class SyncObjectsHandler {
    @NotNull
    private final UC4Job job;

    public SyncObjectsHandler(@NotNull UC4Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.job = job;
    }

    public final void process() {
        if (this.jobHasSyncObjects()) {
            this.handleSyncObject();
        }
    }

    private final void handleSyncObject() {
        this.job.obj.getMultiAttributes(this.getMultiAttributeSyncId()).forEach(arg_0 -> SyncObjectsHandler.handleSyncObject$lambda$0(this, arg_0));
    }

    private final void issueWarningMessageOfMissingSync(String syncRowName) {
        String[] stringArray = new String[]{this.job.getJobName(), syncRowName};
        this.job.addMessage("WRN8075", stringArray);
    }

    private final void handleQuantitativeResource(AttrHolderList syncRules, String syncRowAction, String syncRowName) {
        if (this.job.uc4Type != UC4Globals.UC4_TYPES.JOBS) {
            this.job.issueWarningMessageForTablesWithQuantitativeResource();
        } else {
            int maxValue = this.getMaxValueCheck(syncRules);
            int quant = this.getMaxValueSetForTheAction(syncRowAction, syncRules);
            this.job.addQuantitativeResource(syncRowName, quant);
            String[] stringArray = new String[]{this.job.obj.getName(), this.job.getJobName(), syncRowName, String.valueOf(maxValue)};
            this.job.addMessage("WRN8073", stringArray);
        }
    }

    private final void handleControlResource(AttrHolderList syncStates, String syncRowName) {
        String syncState = this.syncHaveShareStatus(syncStates) ? "S" : "E";
        this.job.addControlResource(syncRowName, syncState);
        String[] stringArray = new String[]{this.job.obj.getName(), this.job.getJobName(), syncRowName, syncState};
        this.job.addMessage("WRN8072", stringArray);
    }

    private final boolean jobHasSyncObjects() {
        return StringsKt.equals((String)this.job.obj.getAttribute("Syncs"), (String)"YES", (boolean)true);
    }

    private final AttrHolderList getMultiSyncAttributesById(UC4Object syncObj, String id) {
        String string = "%s_%s";
        Object[] objectArray = new Object[]{UC4Globals.UC4_TYPES.SYNC, id};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        AttrHolderList attrHolderList = syncObj.getMultiAttributes(string2);
        if (attrHolderList == null) {
            attrHolderList = new AttrHolderList();
        }
        return attrHolderList;
    }

    private final int getMaxValueSetForTheAction(String action, AttrHolderList syncRules) {
        return syncRules.stream().filter(arg_0 -> SyncObjectsHandler.getMaxValueSetForTheAction$lambda$2(arg_0 -> SyncObjectsHandler.getMaxValueSetForTheAction$lambda$1(action, arg_0), arg_0)).mapToInt(arg_0 -> SyncObjectsHandler.getMaxValueSetForTheAction$lambda$4(SyncObjectsHandler::getMaxValueSetForTheAction$lambda$3, arg_0)).max().orElse(0);
    }

    private final int getMaxValueCheck(AttrHolderList syncRules) {
        return syncRules.stream().mapToInt(arg_0 -> SyncObjectsHandler.getMaxValueCheck$lambda$6(SyncObjectsHandler::getMaxValueCheck$lambda$5, arg_0)).max().orElse(0);
    }

    private final boolean syncHaveShareStatus(AttrHolderList states) {
        return states.stream().anyMatch(arg_0 -> SyncObjectsHandler.syncHaveShareStatus$lambda$8(SyncObjectsHandler::syncHaveShareStatus$lambda$7, arg_0));
    }

    private final String getMultiAttributeSyncId() {
        String string = "%s_%s";
        Object[] objectArray = new Object[]{this.job.uc4Type.toString(), "Syncs"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final void handleSyncObject$lambda$0(SyncObjectsHandler this$0, IAttrHolder jobSyncRow) {
        Intrinsics.checkNotNullParameter((Object)jobSyncRow, (String)"jobSyncRow");
        String syncRowName = jobSyncRow.getAttr("row_Name");
        UC4Object syncObj = this$0.job.getSyncObjectByName(syncRowName);
        if (syncObj == null) {
            this$0.issueWarningMessageOfMissingSync(syncRowName);
        } else {
            AttrHolderList syncStates = this$0.getMultiSyncAttributesById(syncObj, "states");
            AttrHolderList syncRules = this$0.getMultiSyncAttributesById(syncObj, "rules");
            if (syncRules.isEmpty() || syncStates.isEmpty()) {
                this$0.issueWarningMessageOfMissingSync(syncRowName);
            } else {
                String syncRowAction = jobSyncRow.getAttr("row_Start");
                if (!StringsKt.equals((String)syncRowAction, (String)"USE", (boolean)true)) {
                    this$0.handleControlResource(syncStates, syncRowName);
                } else {
                    Intrinsics.checkNotNull((Object)syncRowAction);
                    this$0.handleQuantitativeResource(syncRules, syncRowAction, syncRowName);
                }
            }
        }
    }

    private static final boolean getMaxValueSetForTheAction$lambda$1(String $action, IAttrHolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getAttr("row_Action"), (Object)$action);
    }

    private static final boolean getMaxValueSetForTheAction$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int getMaxValueSetForTheAction$lambda$3(IAttrHolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getAttr("row_ValueSet");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttr(...)");
        return Integer.parseInt(string);
    }

    private static final int getMaxValueSetForTheAction$lambda$4(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int getMaxValueCheck$lambda$5(IAttrHolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getAttr("row_ValueCheck");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttr(...)");
        return Integer.parseInt(string);
    }

    private static final int getMaxValueCheck$lambda$6(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final boolean syncHaveShareStatus$lambda$7(IAttrHolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.equals((String)it.getAttr("row_Status"), (String)"SHARE", (boolean)true);
    }

    private static final boolean syncHaveShareStatus$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

