/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J:\u0010\u0019\u001a&\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u001bj\u0002`\u001c0\u001aj\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u001bj\u0002`\u001c`\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0002J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006+"}, d2={"Lcom/bmc/ctmconvert/uc4/PostConditionsHandler;", "", "job", "Lcom/bmc/ctmconvert/uc4/UC4Job;", "<init>", "(Lcom/bmc/ctmconvert/uc4/UC4Job;)V", "taskAttributes", "Lcom/bmc/ctmconvert/common/IAttrHolder;", "kotlin.jvm.PlatformType", "getTaskAttributes", "()Lcom/bmc/ctmconvert/common/IAttrHolder;", "taskAttributes$delegate", "Lkotlin/Lazy;", "process", "", "hasPostConditions", "", "isNotSupportedPostConditionType", "handlePostConditions", "negateConditionStatus", "", "conditionStatus", "generateOnDoStatements", "params", "", "getDestinationToMessageMap", "Ljava/util/LinkedHashMap;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lkotlin/collections/LinkedHashMap;", "addDoShout", "currentDestination", "onStatement", "Lcom/bmc/ctmconvert/ondo/OnStatement;", "message", "isExecuteObjectAction", "param", "isDestinationParam", "trimDestination", "destination", "issueMessageForConvertingPostConditionsToCustomDestinations", "generatedDestinationName", "originalDestinationName", "Scheduler-UC4"})
@SourceDebugExtension(value={"SMAP\nPostConditionsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostConditionsHandler.kt\ncom/bmc/ctmconvert/uc4/PostConditionsHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n216#2,2:135\n774#3:137\n865#3,2:138\n1863#3,2:140\n*S KotlinDebug\n*F\n+ 1 PostConditionsHandler.kt\ncom/bmc/ctmconvert/uc4/PostConditionsHandler\n*L\n68#1:135,2\n80#1:137\n80#1:138,2\n81#1:140,2\n*E\n"})
public final class PostConditionsHandler {
    @NotNull
    private final UC4Job job;
    @NotNull
    private final Lazy taskAttributes$delegate;

    public PostConditionsHandler(@NotNull UC4Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.job = job;
        this.taskAttributes$delegate = LazyKt.lazy(() -> PostConditionsHandler.taskAttributes_delegate$lambda$0(this));
    }

    private final IAttrHolder getTaskAttributes() {
        Lazy lazy = this.taskAttributes$delegate;
        return (IAttrHolder)lazy.getValue();
    }

    public final void process() {
        if (!this.hasPostConditions()) {
            return;
        }
        if (this.isNotSupportedPostConditionType()) {
            String[] stringArray = new String[]{this.job.getOriginalJobName()};
            this.job.addMessage("WRN8031", stringArray);
        } else {
            this.handlePostConditions();
        }
    }

    private final boolean hasPostConditions() {
        return this.getTaskAttributes() != null && Intrinsics.areEqual((Object)this.getTaskAttributes().getAttr("PostCon_conditions"), (Object)"YES");
    }

    private final boolean isNotSupportedPostConditionType() {
        String string = this.getTaskAttributes().getAttr("condition_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttr(...)");
        String conditionId = string;
        return !Intrinsics.areEqual((Object)conditionId, (Object)"STATUS");
    }

    private final void handlePostConditions() {
        block1: {
            AttrHolderList it;
            Predicate<IAttrHolder> predicate = arg_0 -> PostConditionsHandler.handlePostConditions$lambda$1(this, arg_0);
            List<IAttrHolder> list = this.job.getParent().obj.getMultiAttributes("WorkFlow_Condition_params").stream().filter(predicate).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            IAttrHolder postConditionParams = (IAttrHolder)CollectionsKt.first(list);
            String conditionStatus = postConditionParams.getAttr("param_value");
            AttrHolderList attrHolderList = this.job.getParent().obj.getMultiAttributes("WorkFlow_whenAction_params");
            if (attrHolderList != null) {
                it = attrHolderList;
                boolean bl = false;
                List<IAttrHolder> whenParams = it.stream().filter(predicate).toList();
                Intrinsics.checkNotNull(whenParams);
                Intrinsics.checkNotNull((Object)conditionStatus);
                this.generateOnDoStatements(whenParams, conditionStatus);
            }
            AttrHolderList attrHolderList2 = this.job.getParent().obj.getMultiAttributes("WorkFlow_elseAction_params");
            if (attrHolderList2 == null) break block1;
            it = attrHolderList2;
            boolean bl = false;
            List<IAttrHolder> elseParams = it.stream().filter(predicate).toList();
            Intrinsics.checkNotNull(elseParams);
            Intrinsics.checkNotNull((Object)conditionStatus);
            this.generateOnDoStatements(elseParams, this.negateConditionStatus(conditionStatus));
        }
    }

    private final String negateConditionStatus(String conditionStatus) {
        return StringsKt.contains((CharSequence)conditionStatus, (CharSequence)"NOT_OK", (boolean)true) ? "OK" : "NOT_OK";
    }

    private final void generateOnDoStatements(List<? extends IAttrHolder> params, String conditionStatus) {
        boolean isNotOk = StringsKt.contains((CharSequence)conditionStatus, (CharSequence)"NOT_OK", (boolean)true);
        OnStatement onStatement = isNotOk ? (OnStatement)OnStatement.createOnNotOkStatement() : (OnStatement)OnStatement.createOnOkStatement();
        LinkedHashMap<String, StringBuilder> destinationToMessageMap = this.getDestinationToMessageMap(params);
        Map $this$forEach$iv = destinationToMessageMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String destination = (String)entry.getKey();
            StringBuilder messageBuilder = (StringBuilder)entry.getValue();
            String string = messageBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String message = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Intrinsics.checkNotNull((Object)onStatement);
            this.addDoShout(destination, onStatement, message);
        }
        if (onStatement.hasDoStatements()) {
            this.job.addOnDoStmt(onStatement);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashMap<String, StringBuilder> getDestinationToMessageMap(List<? extends IAttrHolder> params) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        LinkedHashMap<String, StringBuilder> destinationMessages = new LinkedHashMap<String, StringBuilder>();
        String currentDestination = null;
        Iterable $this$filter$iv = params;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IAttrHolder it = (IAttrHolder)element$iv$iv;
            boolean bl = false;
            if (!this.isExecuteObjectAction(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            IAttrHolder param = (IAttrHolder)element$iv;
            boolean bl = false;
            if (this.isDestinationParam(param)) {
                String string = currentDestination = param.getAttr("param_value");
                Intrinsics.checkNotNull((Object)string);
                destinationMessages.putIfAbsent(string, new StringBuilder());
                continue;
            }
            if (currentDestination == null || (stringBuilder2 = destinationMessages.get(currentDestination)) == null || (stringBuilder = stringBuilder2.append(param.getAttr("param_value"))) == null) continue;
            stringBuilder.append(" ");
        }
        return destinationMessages;
    }

    private final void addDoShout(String currentDestination, OnStatement onStatement, String message) {
        onStatement.addDo(Do.createDoShout((String)this.trimDestination(currentDestination)).setMessage(message));
        this.issueMessageForConvertingPostConditionsToCustomDestinations(this.trimDestination(currentDestination), currentDestination);
    }

    private final boolean isExecuteObjectAction(IAttrHolder param) {
        return StringsKt.equals((String)param.getAttr("action_Id"), (String)"EXECUTE OBJECT", (boolean)true);
    }

    private final boolean isDestinationParam(IAttrHolder param) {
        return StringsKt.equals((String)param.getAttr("param_name"), (String)"XC_P01", (boolean)true);
    }

    private final String trimDestination(String destination) {
        String string;
        if (destination.length() > 16) {
            String string2 = destination.substring(0, 16);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = destination;
        }
        return string;
    }

    private final void issueMessageForConvertingPostConditionsToCustomDestinations(String generatedDestinationName, String originalDestinationName) {
        String[] stringArray = new String[]{this.job.getOriginalJobName(), generatedDestinationName, originalDestinationName};
        this.job.addMessage("WRN8070", stringArray);
    }

    private static final IAttrHolder taskAttributes_delegate$lambda$0(PostConditionsHandler this$0) {
        return this$0.job.getUc4TaskAttr();
    }

    private static final boolean handlePostConditions$lambda$1(PostConditionsHandler this$0, IAttrHolder it) {
        return Intrinsics.areEqual((Object)it.getAttr("parent_Lnr"), (Object)this$0.getTaskAttributes().getAttr("task_Lnr"));
    }
}

