/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.EmptyAttrHolder;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import java.util.HashMap;
import java.util.List;

public class MFJobsHandler {
    public static final String CTM_DSN = "CTM_DSN";
    private HashMap<IAttrHolder, UC4Job> jobsMap = new HashMap();
    private MfFolderNameHandler mfFolderNameHandler = new MfFolderNameHandler(this);

    public void handle(SchedEntity schedEntity) {
        List<SchedEntity> mfChildren;
        UC4Job uc4Entity = (UC4Job)schedEntity;
        if (uc4Entity.type() == SchedEntity.TYPE.SUB_TABLE && !(mfChildren = uc4Entity.getMFChildren()).isEmpty()) {
            uc4Entity.setChildren(mfChildren);
            uc4Entity.setType(SchedEntity.TYPE.SMART_TABLE);
            uc4Entity.addAttribute("TABLE_DSN", CTM_DSN);
            uc4Entity.addAttribute("PLATFORM", "MVS");
            String folderName = uc4Entity.getOriginalJobName();
            String mfFolderName = this.mfFolderNameHandler.getFolderName(folderName);
            if (!folderName.equals(mfFolderName)) {
                uc4Entity.addMessage("INF8005", folderName, mfFolderName);
            }
            uc4Entity.setName(mfFolderName);
            this.saveMFFolder(uc4Entity);
        }
    }

    private void saveMFFolder(UC4Job uc4Entity) {
        Uc4MfAttr key = new Uc4MfAttr(this.jobsMap.size());
        this.jobsMap.put((IAttrHolder)key, uc4Entity);
    }

    public AttrHolderList getMFSmartFoldersAttrHolder() {
        AttrHolderList mfFolderAtttributeList = new AttrHolderList();
        mfFolderAtttributeList.addAll(this.jobsMap.keySet());
        return mfFolderAtttributeList;
    }

    public UC4Job getSmartFolder(Uc4MfAttr key) {
        return this.jobsMap.get((Object)key);
    }

    public boolean isMfAttr(IAttrHolder attributes) {
        return attributes instanceof Uc4MfAttr;
    }

    public class MfFolderNameHandler {
        private UniqueValueGenerator generator = new UniqueValueGenerator();

        public MfFolderNameHandler(MFJobsHandler this$0) {
        }

        public String getFolderName(String folderName) {
            String MfFolderName = this.generator.getUniqueValue("JOBNAME", folderName, 8);
            return MfFolderName;
        }
    }

    public class Uc4MfAttr
    extends EmptyAttrHolder {
        private int id;

        public Uc4MfAttr() {
            super(new HashMap());
        }

        public Uc4MfAttr(int id) {
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Uc4MfAttr other = (Uc4MfAttr)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.id == other.id;
        }

        private MFJobsHandler getOuterType() {
            return MFJobsHandler.this;
        }
    }
}

