/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectProcessFlow;

public class ConditionFormat {
    static final String PRE_PRE_LNR = "pre_PreLnr";
    private UC4Job uc4Job;

    public ConditionFormat(UC4Job uc4Job) {
        this.uc4Job = uc4Job;
    }

    public String buildConditionName(UC4ObjectProcessFlow processFlow, IAttrHolder jobPred) {
        String format;
        String JOBP_NAME_value = null;
        String FROM_JOB_value = null;
        String TO_JOB_value = null;
        String STATUS_value = null;
        String LNR_value = null;
        String conditionName = format = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        if (format.contains("{JOBP_NAME}")) {
            JOBP_NAME_value = this.uc4Job.getParent().getJobName();
        }
        if (format.contains("{FROM_JOB}")) {
            IAttrHolder fromJobRec = processFlow.getPreRecByLnr(jobPred.getAttr(PRE_PRE_LNR));
            if (fromJobRec != null) {
                FROM_JOB_value = this.uc4Job.getUniqueJobName(fromJobRec);
            } else {
                FROM_JOB_value = "{FROM_JOB}";
                Reporter.addMessage(this.uc4Job.getMessages(), (String)"WRN8021", (String)this.uc4Job.generateUniqueID(), (String[])new String[]{"{FROM_JOB}", "from"});
            }
        }
        if (format.contains("{TO_JOB}")) {
            IAttrHolder toJobRec = processFlow.getPreRecByIdnrAndLnr(jobPred.getAttr("pre"), jobPred.getAttr("parent_Lnr"));
            if (toJobRec != null) {
                TO_JOB_value = this.uc4Job.getUniqueJobName(toJobRec);
            } else {
                TO_JOB_value = "{TO_JOB}";
                Reporter.addMessage(this.uc4Job.getMessages(), (String)"WRN8021", (String)this.uc4Job.generateUniqueID(), (String[])new String[]{"{TO_JOB}", "to"});
            }
        }
        if (format.contains("{STATUS}")) {
            STATUS_value = jobPred.getAttr("pre_When");
        }
        if (format.contains("{LNR}")) {
            LNR_value = jobPred.getAttr(PRE_PRE_LNR);
        }
        if (JOBP_NAME_value != null) {
            conditionName = conditionName.replace("{JOBP_NAME}", JOBP_NAME_value);
        }
        if (FROM_JOB_value != null) {
            conditionName = conditionName.replace("{FROM_JOB}", FROM_JOB_value);
        }
        if (TO_JOB_value != null) {
            conditionName = conditionName.replace("{TO_JOB}", TO_JOB_value);
        }
        if (STATUS_value != null) {
            conditionName = conditionName.replace("{STATUS}", STATUS_value);
        }
        if (LNR_value != null) {
            conditionName = conditionName.replace("{LNR}", LNR_value);
        }
        return this.uc4Job.getFieldValidation().validateAndReturnFixedValue("COND_NAME", conditionName);
    }

    public String buildConditionNameForOutExternalDependency(String external_entity_name, String dependencyName) {
        String conditionName = this.buildCodNameForXTRNL(external_entity_name, dependencyName);
        return conditionName;
    }

    public String buildConditionNameForInExternalDependency(UC4ObjectProcessFlow processFlow, IAttrHolder jobPred) {
        String external_entity_name = processFlow.getTaskObjectByLnr(jobPred.getAttr(PRE_PRE_LNR));
        String format = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        if (format.contains("{TO_JOB}")) {
            String toJob = this.uc4Job.getObj().getName();
            String conditionName = this.buildCodNameForXTRNL(external_entity_name, toJob);
            return conditionName;
        }
        String status = jobPred.getAttr("pre_When");
        String conditionName = this.buildCodNameForXTRNL(external_entity_name, status);
        if (!status.equalsIgnoreCase("ENDED_OK") && !status.equalsIgnoreCase("")) {
            Reporter.addMessage(this.uc4Job.getMessages(), (String)"WRN8011", (String)this.uc4Job.generateUniqueID(), (String[])new String[]{external_entity_name, status, conditionName});
        }
        return conditionName;
    }

    private String buildCodNameForXTRNL(String external_entity_name, String status) {
        Object prefix = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "PREFIX"});
        Object suffix = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "SUFFIX"});
        String delimiter = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "DELIMITER"});
        if (!((String)prefix).equals("")) {
            prefix = (String)prefix + delimiter;
        }
        if (!((String)suffix).equals("")) {
            suffix = delimiter + (String)suffix;
        }
        Object conditionName = (String)prefix + "<XTRNL>_" + external_entity_name + delimiter + status + (String)suffix;
        conditionName = this.uc4Job.getFieldValidation().validateAndReturnFixedValue("COND_NAME", (String)conditionName);
        return conditionName;
    }

    public String buildConditionNameForFileWatcher() {
        String prefix = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "PREFIX"});
        String suffix = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "SUFFIX"});
        String delimiter = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "DELIMITER"});
        Object conditionName = prefix + delimiter + "FileWatcher" + this.uc4Job.upUniqueNumber() + delimiter + this.uc4Job.getObj().getName() + delimiter + "OK" + delimiter + suffix;
        conditionName = this.uc4Job.getFieldValidation().validateAndReturnFixedValue("COND_NAME", (String)conditionName);
        return conditionName;
    }
}

