/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.CommandPredicate;
import com.bmc.ctmconvert.uc4.IUC4Job;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.scripts.IScriptHandler;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class CommandHandler {
    private final UC4Job uc4Job;
    private final UC4Object obj;
    private static final Pattern VARIABLES_PATTERN = Pattern.compile("&(\\w*)#");

    public CommandHandler(UC4Job uc4Job, UC4Object obj) {
        this.uc4Job = uc4Job;
        this.obj = obj;
    }

    public void handleCommandline() {
        CommandPredicate commandPredicate = new CommandPredicate();
        if (commandPredicate.test(this.obj)) {
            this.uc4Job.addAttribute("TASKTYPE", "Command");
            String cmdLine = this.obj.getAttribute("Com");
            cmdLine = cmdLine.isEmpty() ? this.obj.getAttribute("Command") : cmdLine;
            this.uc4Job.validatecmdLine(cmdLine);
            this.uc4Job.addAttribute("CMDLINE", CommandHandler.convertVariablesToControlMFormat(cmdLine));
        }
        this.issuemessageifscriptExist();
    }

    public static String convertVariablesToControlMFormat(String script) {
        return script == null || script.isEmpty() ? script : VARIABLES_PATTERN.matcher(script).replaceAll("%%$1");
    }

    public static boolean containsVar(String ... values) {
        return Arrays.stream(values).anyMatch(value -> value != null && VARIABLES_PATTERN.matcher((CharSequence)value).matches());
    }

    private void issuemessageifscriptExist() {
        this.isuueMessageWhenCommandHasUnhandledPostScript();
        this.isuueMessageWhenCommandHasUnhandledPreScript();
    }

    private void isuueMessageWhenCommandHasUnhandledPostScript() {
        CommandPredicate commandPredicate = new CommandPredicate();
        Uc4JobHaspostScript uc4JobHaspostScript = new Uc4JobHaspostScript();
        boolean hasPostScript = uc4JobHaspostScript.test(this.uc4Job);
        boolean hasCommand = commandPredicate.test(this.obj);
        if (hasCommand && hasPostScript) {
            String postScript = this.obj.getAttribute("OSCRI");
            this.uc4Job.addMessage("WRN8038", this.uc4Job.getOriginalJobName(), postScript, this.uc4Job.generateUniqueID());
        }
    }

    private void isuueMessageWhenCommandHasUnhandledPreScript() {
        CommandPredicate commandPredicate = new CommandPredicate();
        Uc4JobHaspreScript uc4JobHasPreScript = new Uc4JobHaspreScript();
        boolean hasPreScript = uc4JobHasPreScript.test(this.uc4Job);
        boolean hasCommand = commandPredicate.test(this.obj);
        if (hasCommand && hasPreScript) {
            String preScript = this.obj.getAttribute("PSCRI");
            this.uc4Job.addMessage("WRN8037", this.uc4Job.getOriginalJobName(), preScript, this.uc4Job.generateUniqueID());
        }
    }

    private final class Uc4JobHaspostScript
    implements Predicate<IUC4Job> {
        private Uc4JobHaspostScript() {
        }

        @Override
        public boolean test(IUC4Job uc4Job) {
            String postScript = CommandHandler.this.obj.getAttribute("OSCRI");
            IScriptHandler postScriptHandler = uc4Job.getPostScriptHandler();
            boolean hasHandler = postScriptHandler.hasHandler(uc4Job, postScript);
            return !hasHandler && !postScript.isEmpty();
        }
    }

    private class Uc4JobHaspreScript
    implements Predicate<IUC4Job> {
        private Uc4JobHaspreScript() {
        }

        @Override
        public boolean test(IUC4Job uc4Job) {
            String preScript = CommandHandler.this.obj.getAttribute("PSCRI");
            IScriptHandler preScriptHandler = uc4Job.getPreScriptHandler();
            boolean hasHandler = preScriptHandler.hasHandler(uc4Job, preScript);
            return !hasHandler && !preScript.isEmpty();
        }
    }
}

