/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.CITConvertorFactory;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.DBConvertorFactory;
import com.bmc.ctmconvert.uc4.OS400Convertor;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.jobTypes.MVSConvertorFactory;

public class CmConvertorFactory {
    public CmConvertor getConvertor(UC4Job uc4Job, UC4Object obj) {
        String hostType = obj.getAttribute("HostATTR_Type");
        if (OS400Convertor.isOs400Type(hostType)) {
            return new OS400Convertor(uc4Job);
        }
        CITConvertorFactory citConvertorFactory = new CITConvertorFactory(uc4Job);
        if (citConvertorFactory.isCITType()) {
            return citConvertorFactory.getConvertor();
        }
        DBConvertorFactory dbConvertorFactory = new DBConvertorFactory(uc4Job);
        if (dbConvertorFactory.isSQLType()) {
            return dbConvertorFactory.getConvertor();
        }
        if (MVSConvertorFactory.isMVSType(hostType)) {
            return MVSConvertorFactory.from(uc4Job);
        }
        return new EmptyConvertor();
    }

    public static class EmptyConvertor
    implements CmConvertor {
        @Override
        public void convertToCm(UC4Job uc4Job) {
        }
    }
}

