/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.CITWebServicesConverter;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CITWebServicesSoapConverter
extends CITWebServicesConverter {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        XmlElement xml = uc4Job.getJobXmlElement();
        CITWebServicesConverter.ComponentHandler componentHandler = new CITWebServicesConverter.ComponentHandler(xml);
        uc4Job.setAttr("APPL_TYPE", "SOP072023");
        uc4Job.setAttr("TASKTYPE", "Job");
        uc4Job.setAttr("APPL_VER", "9.0.21.000");
        uc4Job.setAttr("APPL_FORM", "SOP072023");
        uc4Job.setAttr("CM_VER", "9.0.21.000");
        String soapConnection = componentHandler.getComponent("webConnection").orElse("");
        String validatedRestConnectionName = UC4ConnectionsHelper.getValidatedConnectionProfileName(soapConnection);
        uc4Job.addAttribute("OWNER", validatedRestConnectionName);
        CITWebServicesSoapConverter.convertAppendRequest_Response(uc4Job, componentHandler);
        uc4Job.addVariable("%%UCM-SOAP_REQUEST_REQ_TYPE", "xml");
        uc4Job.addVariable("%%UCM-ACCOUNT", validatedRestConnectionName);
        uc4Job.addVariable("%%UCM-APP_NAME", "SOP072023");
        String timeOut = CITWebServicesSoapConverter.getWebServiceConnectionTimeoutFromConnectionProfile(uc4Job, soapConnection);
        uc4Job.addVariable("%%UCM-CONN_TIMEOUT", timeOut);
        CITWebServicesSoapConverter.convertXmlRequest(uc4Job, componentHandler);
        this.covertEndPointUrl(uc4Job, componentHandler);
    }

    private static void convertAppendRequest_Response(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        uc4Job.addVariable("%%UCM-APPEND_RESPONSE", CITWebServicesSoapConverter.getValueForAppendReq_Res(componentHandler, "printSOAPResponse"));
        uc4Job.addVariable("%%UCM-APPEND_REQUEST", CITWebServicesSoapConverter.getValueForAppendReq_Res(componentHandler, "printSOAPRequest"));
    }

    @NotNull
    private static String getValueForAppendReq_Res(CITWebServicesConverter.ComponentHandler componentHandler, String printSOAPResponse) {
        return componentHandler.getComponent(printSOAPResponse).orElse("false").equals("false") ? "unchecked" : "checked";
    }

    private void covertEndPointUrl(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        String endPointUrl = componentHandler.getComponent("urlEndpoint").orElse("");
        uc4Job.addVariable("%%UCM-ENDPOINT_URL", endPointUrl);
    }

    private static void convertXmlRequest(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        ToIntFunction<String> extractor = str -> {
            Matcher matcher = Pattern.compile("(\\d+)$").matcher((CharSequence)str);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(1));
            }
            return 0;
        };
        Comparator<String> comparator = Comparator.comparingInt(extractor);
        Optional<List<String>> xmlRequestList = componentHandler.getAllComponentsWithRegex("^xmlRequest_\\d+$", comparator);
        List elements = xmlRequestList.orElse(Collections.emptyList());
        String xmlRequset = String.join((CharSequence)" ", elements);
        uc4Job.addVariable("%%UCM-SOAP_REQUEST_SOAP_REQUEST", xmlRequset);
    }
}

