/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.JobsPredicate;
import com.bmc.ctmconvert.uc4.xmlJobs.UC4XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class XmlGetter {
    Predicate<? super Path> pathPredicate;

    public XmlGetter(Predicate<? super Path> pathPredicate) {
        this.pathPredicate = pathPredicate;
    }

    public XmlGetter() {
        this(new JobsPredicate());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFiles(Path path, UC4XmlReader uc4Reader) {
        try (Stream<Path> paths = Files.list(path);){
            List<? super Path> xmlfiles = paths.filter(this.pathPredicate).toList();
            for (Path path2 : xmlfiles) {
                try {
                    InputStream stream = Files.newInputStream(path2, new OpenOption[0]);
                    try {
                        this.readXmlFile(uc4Reader, stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private void readXmlFile(UC4XmlReader uc4Reader, InputStream stream) {
        uc4Reader.read(stream);
    }
}

