/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.JobsXmlElementCollector;
import com.bmc.ctmconvert.ObjectTableMapGetter;
import com.bmc.ctmconvert.Uc4EntitiesXmlPathPredicate;
import com.bmc.ctmconvert.XmlGetter;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.common.streamutils.InputStreamGetter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rules.FirstDayOfTheWeekRule;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.uc4.CliImporterUC4;
import com.bmc.ctmconvert.uc4.ScriptsHandlerGetter;
import com.bmc.ctmconvert.uc4.UC4AssessmentReport;
import com.bmc.ctmconvert.uc4.UC4CaleConvertor;
import com.bmc.ctmconvert.uc4.UC4Defs;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.dataImport.DataImportUC4;
import com.bmc.ctmconvert.uc4.scripts.Uc4ScriptsMapCreator;
import com.bmc.ctmconvert.uc4.xmlJobs.TagPredicate;
import com.bmc.ctmconvert.uc4.xmlJobs.UC4XmlReader;
import java.awt.Dimension;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class AppData
implements VendorData {
    private FileSystem fileSystem;
    private UC4XmlReader uc4Reader;

    public AppData() {
        this(FileSystems.getDefault());
    }

    public AppData(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public String getName() {
        return "UC4";
    }

    public String getDisplayName() {
        return "Broadcom Automic (UC4)\u00ae";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public DataImportVendor getDataImport() {
        return new DataImportUC4();
    }

    public BasePanel getAssessmentReport(String path) {
        return new UC4AssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, null);
    }

    public CliImporter getCLIImporter() {
        return new CliImporterUC4();
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) {
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        return this.getSourceDefinition(progressBar, rules);
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar, RulesDataSet rules) {
        String dataSourcrDirName = Params.instance().getDatasourcePath();
        Path path = this.fileSystem.getPath(dataSourcrDirName, new String[0]);
        ObjectTableMapGetter objectTableMapGetter = new ObjectTableMapGetter();
        UC4ObjectTablesMap uc4Object = objectTableMapGetter.getObjectTableMap(path, rules);
        XmlGetter xmlGetter = this.createXmlGetter(new Uc4EntitiesXmlPathPredicate());
        String startDayOfWeek = rules.getStringRule("UC4 rules", new String[]{"FIRST_DAY_OF_WEEK"});
        UC4CaleConvertor uc4CaleConvertor = new UC4CaleConvertor(path, startDayOfWeek);
        JobsXmlElementCollector collector = new JobsXmlElementCollector();
        TagPredicate jobPTagPredicate = new TagPredicate("JOBP");
        TagPredicate jobSTagPredicate = new TagPredicate("JOBS_");
        TagPredicate jschTagPredicate = new TagPredicate("JSCH");
        Predicate<String> uc4EntitiesTagPredcate = jobSTagPredicate.or(jobPTagPredicate).or(jschTagPredicate);
        this.uc4Reader = this.createUc4XmlReader(uc4EntitiesTagPredcate);
        this.uc4Reader.addHandler(collector);
        xmlGetter.readFiles(path, this.uc4Reader);
        Map<String, XmlElement> mapJobNametoXmlElement = collector.getXmlMap();
        Path dataSourcrPath = this.fileSystem.getPath(Params.instance().getDatasourcePath(), new String[0]);
        Path scriptXlsFilePath = dataSourcrPath.resolve("UC4_scripts_conversion_to_ctm.xlsx");
        ScriptsHandlerGetter getter = new ScriptsHandlerGetter(scriptXlsFilePath);
        Uc4ScriptsMapCreator creator = this.getScriptsMapCreator(scriptXlsFilePath);
        return new UC4Defs(rules, uc4Object, mapJobNametoXmlElement, uc4CaleConvertor, getter, creator);
    }

    @NotNull
    Uc4ScriptsMapCreator getScriptsMapCreator(Path scriptXlsFilePath) {
        return new Uc4ScriptsMapCreator(scriptXlsFilePath, new InputStreamGetter());
    }

    UC4XmlReader createUc4XmlReader(Predicate<String> uc4EntitiesTagPredcate) {
        return new UC4XmlReader(uc4EntitiesTagPredcate);
    }

    XmlGetter createXmlGetter(Uc4EntitiesXmlPathPredicate pathPredicate) {
        return new XmlGetter(pathPredicate);
    }

    public InputStream getRulesResourceFile() {
        InputStream fileStream = AppData.class.getResourceAsStream("/rules.xml");
        return fileStream;
    }

    public boolean isZOS() {
        return false;
    }

    public Dimension getSize() {
        return new Dimension(670, 740);
    }

    public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        return FirstDayOfTheWeekRule.getFirstDayOfTheWeek((String)"UC4 rules", (String)"FIRST_DAY_OF_WEEK");
    }
}

