/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.maybe.conditions.ConditionNameUpdater;
import com.bmc.ctmconvert.maybe.conditions.ConditionSpliter;
import com.bmc.ctmconvert.maybe.conditions.CtmEntityUpdater;
import com.bmc.ctmconvert.maybe.conditions.JobRecordStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutConditionAdder
extends CtmEntityUpdater {
    private String conditionName;
    private final String sign;
    private final String prefixToAdd;
    private final ConditionSpliter conditionSpliter;

    public OutConditionAdder(String conditionName, String prefixToAdd, String sign, JobRecordStatus status, String line) {
        this.conditionName = conditionName;
        this.prefixToAdd = prefixToAdd;
        this.sign = sign;
        this.status = status;
        this.line = line;
        this.conditionSpliter = new ConditionSpliter(conditionName);
    }

    @Override
    public void update(XmlElement ctmEntity) {
        this.processed = true;
        String jobname = ctmEntity.getAttribute("JOBNAME");
        if (jobname == null || jobname.isEmpty()) {
            jobname = ctmEntity.getAttribute("MEMNAME");
        }
        String jobFirstChar = jobname.substring(0, 1);
        String sourceJobName = this.conditionSpliter.getSourceJob();
        String targetJobName = this.conditionSpliter.getTargetJob();
        String sourceJobFirstChar = jobFirstChar.toUpperCase();
        if (Character.isLowerCase(sourceJobName.charAt(0))) {
            sourceJobFirstChar = jobFirstChar.toLowerCase();
        }
        String targetJobFirstChar = jobFirstChar.toUpperCase();
        if (Character.isLowerCase(targetJobName.charAt(0))) {
            targetJobFirstChar = jobFirstChar.toLowerCase();
        }
        Object prefixToAddWithGlobal = this.prefixToAdd;
        if (!sourceJobFirstChar.equals(targetJobFirstChar)) {
            prefixToAddWithGlobal = "GC-" + this.prefixToAdd;
        }
        this.conditionName = (String)prefixToAddWithGlobal + sourceJobFirstChar + sourceJobName + "-" + targetJobFirstChar + targetJobName;
        try {
            if (this.alreadyHaveTheCondition(ctmEntity)) {
                this.renameCondition(ctmEntity);
            } else {
                Document ownerDocument = ctmEntity.getElement().getOwnerDocument();
                XmlElement outCondElement = this.getOutCondElement(ownerDocument);
                ctmEntity.addChildAt(outCondElement, 0);
            }
        }
        catch (Exception e) {
            this.status.setStatus("Failure");
        }
        this.status.setStatus("Success");
        if (jobname.contains(".")) {
            Logger.getLogger().writeToLogOnly("Out cond was added to qualified job: " + jobname);
        }
    }

    private boolean alreadyHaveTheCondition(XmlElement ctmEntity) {
        String conditionToLookFor = this.conditionName.substring(2);
        XmlElement incond = ctmEntity.getFirstChildElementByAttrValue("OUTCOND", "NAME", conditionToLookFor);
        return incond != null;
    }

    private void renameCondition(XmlElement ctmEntity) {
        String conditionToLookFor = this.conditionSpliter.getFullConNameWithInsertion("");
        Logger.getLogger().writeToLogOnly("Condition only renamed since already exists: " + conditionToLookFor);
        ConditionNameUpdater conditionUpdater = new ConditionNameUpdater("OUTCOND", conditionToLookFor, "I-", this.status, this.line);
        conditionUpdater.update(ctmEntity);
        this.status = conditionUpdater.getStatus();
        this.status.setAction(this.status.getAction() + " - exists so renamed only");
    }

    private XmlElement getOutCondElement(Document doc) {
        Element outCondElement = doc.createElement("OUTCOND");
        outCondElement.setAttribute("NAME", this.conditionName);
        outCondElement.setAttribute("ODATE", "ODAT");
        outCondElement.setAttribute("SIGN", this.sign);
        return new XmlElement(outCondElement);
    }
}

