/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.maybe.conditions.ConditionNameUpdater;
import com.bmc.ctmconvert.maybe.conditions.CtmEntityUpdater;
import com.bmc.ctmconvert.maybe.conditions.InConditionAdder;
import com.bmc.ctmconvert.maybe.conditions.JobRecordStatus;
import com.bmc.ctmconvert.maybe.conditions.MaybeCondJobPath;
import com.bmc.ctmconvert.maybe.conditions.OutConditionAdder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LoadMaybeCondList {
    private Map<String, List<CtmEntityUpdater>> jobActionsMap;
    private String maybePrefixToAdd;
    private String inheritPrefixToAdd;

    public LoadMaybeCondList(Map<String, List<CtmEntityUpdater>> jobActionsMap, String maybePrefixToAdd, String inheritPrefixToAdd) {
        this.jobActionsMap = jobActionsMap;
        this.maybePrefixToAdd = maybePrefixToAdd;
        this.inheritPrefixToAdd = inheritPrefixToAdd;
    }

    public Map<String, List<CtmEntityUpdater>> load(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String line = "";
        try {
            while ((line = bufferedReader.readLine()) != null) {
                String[] lineItems = line.split("\\s+");
                if (lineItems.length < 7) {
                    Logger.getLogger().writeToLog("Ignored: " + line);
                    continue;
                }
                String type = lineItems[3];
                if (type.equalsIgnoreCase("(A)")) {
                    Logger.getLogger().writeToLog("(A) line: " + line);
                    continue;
                }
                String folderName = lineItems[4];
                String jobName = lineItems[5];
                String conditionName = lineItems[6];
                if (!type.contains("*")) {
                    if (lineItems.length < 8) {
                        Logger.getLogger().writeToLog("Ignored: " + line);
                        continue;
                    }
                    folderName = lineItems[5];
                    jobName = lineItems[6];
                    if (lineItems.length < 6) {
                        Logger.getLogger().writeToLog("Illegal line: " + line);
                        continue;
                    }
                    conditionName = lineItems[7];
                }
                switch (type) {
                    case "MAYBE": 
                    case "M*C": {
                        MaybeCondJobPath maybeCondJobPath = new MaybeCondJobPath(folderName, jobName.substring(1));
                        String conditionToLookFor = conditionName;
                        List<CtmEntityUpdater> actionList = this.getActionList(maybeCondJobPath);
                        StringBuilder action = new StringBuilder();
                        action.append("add ");
                        action.append("'" + this.maybePrefixToAdd + "' prefix to ");
                        action.append("In Condition");
                        JobRecordStatus status = this.initStatusTemplate(folderName + "/" + jobName, conditionToLookFor, action.toString());
                        ConditionNameUpdater inConditionNameUpdater = new ConditionNameUpdater("INCOND", conditionToLookFor, this.maybePrefixToAdd, status, line);
                        actionList.add(inConditionNameUpdater);
                        action = new StringBuilder();
                        action.append("add ");
                        action.append("'" + this.maybePrefixToAdd + "' prefix to ");
                        action.append("OUT Condition-cleanup");
                        status = this.initStatusTemplate(folderName + "/" + jobName, conditionToLookFor, action.toString());
                        ConditionNameUpdater outDelConditionNameUpdater = new ConditionNameUpdater("OUTCOND", conditionToLookFor, this.maybePrefixToAdd, status, line);
                        actionList.add(outDelConditionNameUpdater);
                        String[] condNameParts = conditionToLookFor.split("-");
                        String sourceJob = condNameParts[0];
                        maybeCondJobPath = new MaybeCondJobPath(folderName, sourceJob.substring(1));
                        actionList = this.getActionListNoFolder(sourceJob.substring(1));
                        action = new StringBuilder();
                        action.append("add ");
                        action.append("'" + this.maybePrefixToAdd + "' prefix to ");
                        action.append("OUT Condition-create");
                        status = this.initStatusTemplate(folderName + "/" + jobName, conditionToLookFor, action.toString());
                        ConditionNameUpdater outAddConditionNameUpdater = new ConditionNameUpdater("OUTCOND", conditionToLookFor, this.maybePrefixToAdd, status, line);
                        actionList.add(outAddConditionNameUpdater);
                        break;
                    }
                    case "INHERTD": 
                    case "I*P": {
                        MaybeCondJobPath maybeCondJobPath = new MaybeCondJobPath(folderName, jobName.substring(1));
                        String conditionToLookFor = conditionName;
                        List<CtmEntityUpdater> actionList = this.getActionList(maybeCondJobPath);
                        StringBuilder action = new StringBuilder();
                        action.append("add new In Condition with prefix '" + this.inheritPrefixToAdd + "'");
                        JobRecordStatus status = this.initStatusTemplate(folderName + "/" + jobName, conditionToLookFor, action.toString());
                        actionList.add(new InConditionAdder(conditionToLookFor, this.inheritPrefixToAdd, status, line));
                        action = new StringBuilder();
                        action.append("add new OUT Condition-cleanup with prefix '" + this.inheritPrefixToAdd + "'");
                        status = this.initStatusTemplate(folderName + "/" + jobName, conditionToLookFor, action.toString());
                        actionList.add(new OutConditionAdder(conditionToLookFor, this.inheritPrefixToAdd, "-", status, line));
                        String[] condNameParts = conditionToLookFor.split("-");
                        String sourceJob = condNameParts[0];
                        actionList = this.getActionListNoFolder(sourceJob.substring(1));
                        action = new StringBuilder();
                        action.append("add new OUT Condition-create with prefix '" + this.inheritPrefixToAdd + "'");
                        status = this.initStatusTemplate(jobName, conditionToLookFor, action.toString());
                        actionList.add(new OutConditionAdder(conditionToLookFor, this.inheritPrefixToAdd, "+", status, line));
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.jobActionsMap;
    }

    private List<CtmEntityUpdater> getActionList(MaybeCondJobPath maybeCondJobPath) {
        ArrayList<CtmEntityUpdater> actionList;
        String jobPath = maybeCondJobPath.getpath();
        if (this.jobActionsMap.containsKey(jobPath)) {
            actionList = this.jobActionsMap.get(jobPath);
        } else {
            actionList = new ArrayList();
            this.jobActionsMap.put(jobPath, actionList);
        }
        return actionList;
    }

    private List<CtmEntityUpdater> getActionListNoFolder(String jobname) {
        ArrayList<CtmEntityUpdater> actionList;
        String jobPath = jobname;
        if (this.jobActionsMap.containsKey(jobPath)) {
            actionList = this.jobActionsMap.get(jobPath);
        } else {
            actionList = new ArrayList();
            this.jobActionsMap.put(jobPath, actionList);
        }
        return actionList;
    }

    private JobRecordStatus initStatusTemplate(String jobParentPath, String conditionToLookFor, String action) {
        JobRecordStatus status = new JobRecordStatus();
        status = new JobRecordStatus(jobParentPath, conditionToLookFor, action, "");
        return status;
    }
}

