/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.maybe.conditions.ConditionNameUpdater;
import com.bmc.ctmconvert.maybe.conditions.ConditionSpliter;
import com.bmc.ctmconvert.maybe.conditions.CtmEntityUpdater;
import com.bmc.ctmconvert.maybe.conditions.JobRecordStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InConditionAdder
extends CtmEntityUpdater {
    private String conditionName;
    private final String prefixToAdd;
    private final ConditionSpliter conditionSpliter;

    public InConditionAdder(String conditionName, String prefixToAdd, JobRecordStatus status, String line) {
        this.prefixToAdd = prefixToAdd;
        this.line = line;
        this.conditionSpliter = new ConditionSpliter(conditionName);
        this.status = status;
    }

    @Override
    public void update(XmlElement ctmEntity) {
        String jobname = ctmEntity.getAttribute("JOBNAME");
        if (jobname == null || jobname.isEmpty()) {
            jobname = ctmEntity.getAttribute("MEMNAME");
        }
        String jobFirstChar = jobname.substring(0, 1);
        String sourceJobName = this.conditionSpliter.getSourceJob();
        String targetJobName = this.conditionSpliter.getTargetJob();
        String sourceJobFirstChar = jobFirstChar.toUpperCase();
        if (Character.isLowerCase(sourceJobName.charAt(0))) {
            sourceJobFirstChar = jobFirstChar.toLowerCase();
        }
        String targetJobFirstChar = jobFirstChar.toUpperCase();
        if (Character.isLowerCase(targetJobName.charAt(0))) {
            targetJobFirstChar = jobFirstChar.toLowerCase();
        }
        Object prefixToAddWithGlobal = this.prefixToAdd;
        if (!sourceJobFirstChar.equals(targetJobFirstChar)) {
            prefixToAddWithGlobal = "GC-" + this.prefixToAdd;
        }
        this.conditionName = (String)prefixToAddWithGlobal + sourceJobFirstChar + sourceJobName + "-" + targetJobFirstChar + targetJobName;
        try {
            Document ownerDocument = ctmEntity.getElement().getOwnerDocument();
            if (this.alreadyHaveTheCondition(ctmEntity)) {
                this.renameCondition(ctmEntity);
            } else {
                XmlElement inCondElement = this.getInCondElement(ownerDocument);
                ctmEntity.addChildAt(inCondElement, 0);
            }
        }
        catch (Exception e) {
            this.status.setStatus("Failure");
        }
        this.status.setStatus("Success");
        this.processed = true;
    }

    private boolean alreadyHaveTheCondition(XmlElement ctmEntity) {
        String conditionToLookFor = this.conditionName.substring(2);
        XmlElement incond = ctmEntity.getFirstChildElementByAttrValue("INCOND", "NAME", conditionToLookFor);
        return incond != null;
    }

    private void renameCondition(XmlElement ctmEntity) {
        String conditionToLookFor = this.conditionSpliter.getFullConNameWithInsertion("");
        Logger.getLogger().writeToLogOnly("Condition only renamed since already exists: " + conditionToLookFor);
        ConditionNameUpdater conditionUpdater = new ConditionNameUpdater("INCOND", conditionToLookFor, "I-", this.status, this.line);
        conditionUpdater.update(ctmEntity);
        this.status = conditionUpdater.getStatus();
        this.status.setAction(this.status.getAction() + " - exists so renamed only");
    }

    private XmlElement getInCondElement(Document doc) {
        Element inCondElement = doc.createElement("INCOND");
        inCondElement.setAttribute("NAME", this.conditionName);
        inCondElement.setAttribute("ODATE", "ODAT");
        inCondElement.setAttribute("AND_OR", "A");
        return new XmlElement(inCondElement);
    }
}

