/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.maybe.conditions.ConditionSpliter;
import com.bmc.ctmconvert.maybe.conditions.CtmEntityUpdater;
import com.bmc.ctmconvert.maybe.conditions.JobRecordStatus;
import com.bmc.ctmconvert.maybe.conditions.MaybeCondJobPath;
import java.util.List;
import java.util.Map;

public class CtmDraftUpdater {
    private Map<String, List<CtmEntityUpdater>> entity2updatersMap;

    public CtmDraftUpdater(Map<String, List<CtmEntityUpdater>> entity2updatersMap) {
        this.entity2updatersMap = entity2updatersMap;
    }

    public XmlElement updateJobs(XmlElement root) {
        List jobs = root.getAllDecnedElementByName("JOB");
        jobs.forEach(job -> {
            List<CtmEntityUpdater> updaters;
            MaybeCondJobPath jobPath;
            String qualifiedName;
            String jobname = job.getAttribute("JOBNAME");
            if (jobname == null || jobname.isEmpty()) {
                jobname = job.getAttribute("MEMNAME");
            }
            if ((qualifiedName = this.extractQualifiedName((XmlElement)job)) == null) {
                qualifiedName = jobname;
            }
            if (this.entity2updatersMap.containsKey((jobPath = new MaybeCondJobPath(job.getAttribute("PARENT_FOLDER"), qualifiedName.substring(1))).getpath()) && (updaters = this.entity2updatersMap.get(jobPath.getpath())) != null) {
                updaters.forEach(updater -> {
                    if (updater.isProcessed()) {
                        JobRecordStatus status = updater.getStatus();
                        status.setAction(status.getAction() + " - multiple occurences of job in same folder - please verify manually");
                        Logger.getLogger().writeToLogOnly("Job already processed: " + job.getAttribute("DESCRIPTION") + " line: " + updater.getLine());
                    }
                    updater.update((XmlElement)job);
                });
            }
            if (this.entity2updatersMap.containsKey(jobname.substring(1)) && (updaters = this.entity2updatersMap.get(jobname.substring(1))) != null) {
                updaters.forEach(updater -> {
                    if (updater.isProcessed()) {
                        JobRecordStatus status = updater.getStatus();
                        status.setAction(status.getAction() + " - multiple occurences of job - please verify manually");
                        Logger.getLogger().writeToLogOnly("Add out cond for that job already processed: " + job.getAttribute("DESCRIPTION") + " line: " + updater.getLine());
                    }
                    updater.update((XmlElement)job);
                });
            }
        });
        return root;
    }

    private String extractQualifiedName(XmlElement job) {
        List inConds = job.getDirectchildsElementbyName("INCOND");
        if (inConds != null && inConds.size() > 0) {
            XmlElement targetInCond;
            String condName = "";
            for (int i = 0; i < inConds.size() && (condName = (targetInCond = (XmlElement)inConds.get(i)).getAttribute("NAME")).startsWith("DS+"); ++i) {
            }
            if (condName.startsWith("DS+")) {
                return null;
            }
            ConditionSpliter currentConditionSpliter = new ConditionSpliter(condName);
            String qualifiedJobName = currentConditionSpliter.getTargetJobPrefix() + currentConditionSpliter.getTargetJob();
            return qualifiedJobName;
        }
        List outConds = job.getDirectchildsElementbyName("OUTCOND");
        if (outConds != null && outConds.size() > 0) {
            String condName = "";
            for (int i = 0; i < outConds.size(); ++i) {
                XmlElement targetOutCond = (XmlElement)outConds.get(i);
                condName = targetOutCond.getAttribute("NAME");
            }
            ConditionSpliter currentConditionSpliter = new ConditionSpliter(condName);
            String qualifiedJobName = currentConditionSpliter.getSourceJobPrefix() + currentConditionSpliter.getSourceJob();
            return qualifiedJobName;
        }
        return null;
    }
}

