/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.maybe.conditions.ConditionSpliter;
import com.bmc.ctmconvert.maybe.conditions.CtmEntityUpdater;
import com.bmc.ctmconvert.maybe.conditions.JobRecordStatus;
import java.util.List;
import java.util.Optional;

public class ConditionNameUpdater
extends CtmEntityUpdater {
    private String conditionToLookFor;
    private String targetConditionName;
    private String conditionType;
    private String prefixToAdd;
    private ConditionSpliter conditionSpliter;
    private String jobname;

    public ConditionNameUpdater(String conditionType, String conditionToLookFor, String prefixToAdd, JobRecordStatus status, String line) {
        this.conditionType = conditionType;
        this.conditionToLookFor = conditionToLookFor;
        this.prefixToAdd = prefixToAdd;
        this.status = status;
        this.line = line;
        this.conditionSpliter = new ConditionSpliter(conditionToLookFor);
    }

    @Override
    public void update(XmlElement ctmEntity) {
        List inConds;
        this.jobname = ctmEntity.getAttribute("JOBNAME");
        if (this.jobname == null || this.jobname.isEmpty()) {
            this.jobname = ctmEntity.getAttribute("MEMNAME");
        }
        if ((inConds = ctmEntity.getDirectchildsElementbyName(this.conditionType)) != null) {
            Optional<XmlElement> targetInCondOpt = inConds.stream().filter(inCond -> {
                String condName = inCond.getAttribute("NAME");
                ConditionSpliter currentConditionSpliter = new ConditionSpliter(condName);
                return currentConditionSpliter.compareCond(this.conditionSpliter.getSourceJob(), this.conditionSpliter.getTargetJob());
            }).findFirst();
            if (targetInCondOpt.isPresent()) {
                XmlElement targetInCond = targetInCondOpt.get();
                String condName = targetInCond.getAttribute("NAME");
                if (!condName.startsWith(this.prefixToAdd)) {
                    ConditionSpliter currentConditionSpliter = new ConditionSpliter(condName);
                    this.targetConditionName = currentConditionSpliter.getFullConNameWithInsertion(this.prefixToAdd);
                    targetInCond.setAttribute("NAME", this.targetConditionName);
                    this.status.setStatus("Success");
                    this.processed = true;
                } else {
                    this.status.setStatus("Success - Prefix added previously");
                    Logger.getLogger().writeToLogOnly("Condtion prefix added previously - conditionToLookFor=" + this.conditionToLookFor + " prefixToAdd=" + this.prefixToAdd);
                }
            } else {
                this.status.setStatus("Failure - Condtion Not Found");
                Logger.getLogger().writeToLogOnly("Condtion Not Found - conditionToLookFor=" + this.conditionToLookFor + " prefixToAdd=" + this.prefixToAdd);
            }
        } else {
            this.status.setStatus("Failure - No Condtion Elements");
        }
    }
}

