/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer.criticalpath;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.criticalpath.DependenciesHandler;
import com.bmc.toolbox.compare.condition_compare.entitites.Condition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DependenciesGetter {
    private Set<EntityNode> dependenciesList = new HashSet<EntityNode>();
    private DependenciesHandler dependenciesHandler;

    public void createDependenciesList(EntityNode criticalEntity, DependenciesHandler dependenciesHandler) {
        this.dependenciesList = new HashSet<EntityNode>();
        this.dependenciesHandler = dependenciesHandler;
        this.iterateOverDependencies(criticalEntity);
    }

    private void iterateOverDependencies(EntityNode entity) {
        List<Condition> entityConditions = this.dependenciesHandler.getConditions(entity);
        if (entityConditions == null) {
            return;
        }
        for (Condition condition : entityConditions) {
            List<EntityNode> directDependencieslist = this.dependenciesHandler.getDirectDependencies(condition);
            if (directDependencieslist == null) continue;
            directDependencieslist.stream().forEach(node -> {
                if (this.isCleanupCondition(entity, (EntityNode)node) || this.dependenciesList.contains(node)) {
                    return;
                }
                this.dependenciesList.add((EntityNode)node);
                if (!node.getType().equals("Job")) {
                    this.handleSubEntities((EntityNode)node);
                }
                this.iterateOverDependencies((EntityNode)node);
            });
        }
    }

    private void handleSubEntities(EntityNode parentNode) {
        this.addAllSubEntitiesRecursively(parentNode);
        parentNode.getChildrenNodes().forEach(childNode -> this.iterateOverDependencies((EntityNode)childNode));
    }

    private void addAllSubEntitiesRecursively(EntityNode parentNode) {
        List<EntityNode> childrenNodes = parentNode.getChildrenNodes();
        if (childrenNodes == null) {
            return;
        }
        for (EntityNode childNode : childrenNodes) {
            this.dependenciesList.add(childNode);
            this.addAllSubEntitiesRecursively(childNode);
        }
    }

    private boolean isCleanupCondition(EntityNode entity, EntityNode node) {
        return node.equals(entity);
    }

    public List<EntityNode> getDependenciesList() {
        return new ArrayList<EntityNode>(this.dependenciesList);
    }
}

