/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.ReaderHandler;
import com.bmc.ctmconvert.draftanalyzer.XmlPredicatorService;
import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.draftReader.EntitesCreator;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderUtils;
import com.bmc.toolbox.compare.condition_compare.entitites.Folder;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.entitites.SmartFolder;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class TopLevelEntityReader {
    private EntitesCreator entitesCreator;
    private ReaderHandler readerHandler;
    private List<MyAttribute> attributes;
    private DraftEntityImp entityImp;

    public TopLevelEntityReader(ReaderHandler readerHandler, EntitesCreator entitesCreator) {
        this.entitesCreator = entitesCreator;
        this.readerHandler = readerHandler;
        this.attributes = null;
    }

    public EntityNode readTopLevelEntity(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent xmlEvent = eventReader.nextEvent();
        this.entityImp = null;
        if (XmlPredicatorService.isStartOfSmartFolder(xmlEvent)) {
            this.entityImp = this.readSmartFolder(xmlEvent);
        }
        if (XmlPredicatorService.isStartOfFolder(xmlEvent)) {
            this.entityImp = this.readFolder(xmlEvent);
        }
        if (this.entityImp != null) {
            return this.read(this.entityImp, eventReader);
        }
        return null;
    }

    private SmartFolder readSmartFolder(XMLEvent smartEvent) {
        this.attributes = ReaderUtils.getEventAttributes((XMLEvent)smartEvent);
        return this.entitesCreator.createSmartFolder(smartEvent, this.getEntityDraftPath());
    }

    private Folder readFolder(XMLEvent folderEvent) {
        this.attributes = ReaderUtils.getEventAttributes((XMLEvent)folderEvent);
        return this.entitesCreator.createFolder(folderEvent, this.getEntityDraftPath());
    }

    private EntityNode read(DraftEntityImp entityImp, XMLEventReader eventReader) throws XMLStreamException {
        EntityNode rootNode = new EntityNode(entityImp);
        this.readerHandler.setFolderOSType(rootNode, this.attributes);
        this.readerHandler.readDescendants(eventReader, rootNode);
        return rootNode;
    }

    private DraftPath getEntityDraftPath() {
        String folderName = this.readerHandler.getValueFromAttributeList("FOLDER_NAME", this.attributes);
        return new DraftPath(folderName);
    }
}

