/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.DividorGlobals;
import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import java.util.HashSet;
import java.util.Set;

public class GroupService {
    public Set<EntityNode> getEntityGroup(EntityNode entityNode) {
        if (entityNode != null) {
            return entityNode.getGroup();
        }
        return null;
    }

    public Set<Set<EntityNode>> getGroupsSetOfRelatives(EntityNode entity, Set<EntityNode> condEntitySet) {
        Set<Set<EntityNode>> childrenGroupList = this.getGroupsOfChildrenEntities(entity);
        Set<Set<EntityNode>> conditionedGroups = this.getAllEntitiesGroups(condEntitySet);
        Set<Set<EntityNode>> combinedGroupsSet = this.combineGroupSets(conditionedGroups, childrenGroupList);
        EntityNode parentNode = entity.getParentNode();
        if (parentNode != null) {
            this.addEntityGroupToContainer(combinedGroupsSet, parentNode);
        }
        this.addEntityGroupToContainer(combinedGroupsSet, entity);
        return combinedGroupsSet;
    }

    public Set<Set<EntityNode>> getGroupsOfChildrenEntities(EntityNode entityNode) {
        HashSet<EntityNode> childrenSet = new HashSet<EntityNode>(entityNode.getChildrenNodes());
        return this.getAllEntitiesGroups(childrenSet);
    }

    public Set<Set<EntityNode>> getAllEntitiesGroups(Set<EntityNode> entitySet) {
        HashSet<Set<EntityNode>> groupsContainer = new HashSet<Set<EntityNode>>();
        for (EntityNode entity : entitySet) {
            this.addEntityGroupToContainer(groupsContainer, entity);
        }
        return groupsContainer;
    }

    public void addEntityGroupToContainer(Set<Set<EntityNode>> groupsContainer, EntityNode entity) {
        Set<EntityNode> tempGroup = entity.getGroup();
        if (tempGroup != null && groupsContainer != null) {
            groupsContainer.add(tempGroup);
        }
    }

    public DividorGlobals.AmountOfGroups howManyGroups(Set<Set<EntityNode>> groupsContainer) {
        int size = 0;
        if (groupsContainer != null) {
            size = groupsContainer.size();
        }
        if (size == 0) {
            return DividorGlobals.AmountOfGroups.None;
        }
        if (size == 1) {
            return DividorGlobals.AmountOfGroups.One;
        }
        if (size > 1) {
            return DividorGlobals.AmountOfGroups.MoreThenOne;
        }
        return DividorGlobals.AmountOfGroups.None;
    }

    public Set<Set<EntityNode>> combineGroupSets(Set<Set<EntityNode>> groupSetA, Set<Set<EntityNode>> groupSetB) {
        HashSet<Set<EntityNode>> groupsContainer = new HashSet<Set<EntityNode>>();
        groupsContainer.addAll(groupSetA);
        groupsContainer.addAll(groupSetB);
        return groupsContainer;
    }
}

