/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.ConditionHandler;
import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.StringService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class EntityTree
extends HashMap<String, EntityNode> {
    private static final long serialVersionUID = 1L;
    private ConditionHandler conditionHandler = null;

    public EntityTree(ConditionHandler conditionHandler) {
        this.conditionHandler = conditionHandler;
    }

    public ConditionHandler getConditionHandler() {
        return this.conditionHandler;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EntityTree)) {
            return false;
        }
        EntityTree entityTree = (EntityTree)object;
        return this.compareEntityTree(entityTree);
    }

    private boolean sameNumberOfRoots(EntityTree entityTree) {
        return this.size() == entityTree.size();
    }

    private EntityNode getRoot(EntityTree entityTree, String path) {
        return (EntityNode)entityTree.get(path);
    }

    public EntityNode getNodeByPath(String path) {
        if (path == null) {
            return null;
        }
        List<String> pathList = StringService.getPathAsList(path);
        if (pathList == null || pathList.isEmpty()) {
            return null;
        }
        String rootPath = pathList.get(0);
        EntityNode rootNode = (EntityNode)this.get(rootPath);
        if (rootNode == null) {
            return null;
        }
        return rootNode.getEntityByPath(path);
    }

    private boolean equalEntities(EntityNode source1, EntityNode source2) {
        if (source1 == null || source2 == null) {
            return false;
        }
        return source1.compareParameters(source2);
    }

    public Collection<EntityNode> getRoots() {
        return this.values();
    }

    private boolean compareEntityTree(EntityTree entityTree) {
        if (!this.sameNumberOfRoots(entityTree)) {
            return false;
        }
        for (EntityNode root : this.getRoots()) {
            if (this.equalEntities(root, this.getRoot(entityTree, root.getPathAsString()))) continue;
            return false;
        }
        return true;
    }

    public int getNumberOfEntities() {
        int count = 0;
        for (EntityNode root : this.getRoots()) {
            count += this.getEntityCount(root) + 1;
        }
        return count;
    }

    private int getEntityCount(EntityNode root) {
        List<EntityNode> childrenNodes = root.getChildrenNodes();
        if (childrenNodes == null || childrenNodes.isEmpty()) {
            return 0;
        }
        int count = childrenNodes.size();
        for (EntityNode node : childrenNodes) {
            count += this.getEntityCount(node);
        }
        return count;
    }

    public boolean hasMoreThanOneEntityWithSamePath(EntityNode criticalEntity) {
        if (criticalEntity.getType() != "Job") {
            return false;
        }
        int count = 0;
        for (EntityNode node : criticalEntity.getParentNode().getChildrenNodes()) {
            if (!node.getPathAsString().equals(criticalEntity.getPathAsString())) continue;
            ++count;
        }
        return count > 1;
    }
}

