/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.ConditionHandler;
import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.EntityTree;
import com.bmc.ctmconvert.draftanalyzer.ReaderHandler;
import com.bmc.ctmconvert.draftanalyzer.ReaderService;
import com.bmc.toolbox.compare.condition_compare.draftReader.EntitesCreator;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class DraftReader {
    private EntityTree entityTree = null;
    private ReaderHandler readerHandler;
    private EntitesCreator entitesCreator;
    private XMLEventReader eventReader;
    private ReaderService readerService;

    private void createReaderService() {
        this.entitesCreator = new EntitesCreator();
        this.readerHandler = new ReaderHandler(this.entityTree);
        this.readerService = new ReaderService(this.readerHandler, this.entitesCreator);
        this.readerHandler.setReaderService(this.readerService);
    }

    public void read(InputStream inputStreamXML) {
        this.entityTree = new EntityTree(new ConditionHandler());
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.eventReader = factory.createXMLEventReader(inputStreamXML);
            this.createReaderService();
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.peek();
                this.readRoot(event);
                XMLEvent xMLEvent = this.eventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void readRoot(XMLEvent event) throws XMLStreamException {
        EntityNode rootNode = null;
        rootNode = this.readerService.read(this.eventReader);
        if (rootNode != null) {
            this.entityTree.put(rootNode.getPathAsString(), rootNode);
        }
    }

    public EntityTree getEntityTree() {
        return this.entityTree;
    }
}

