/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CalendarXmlElement;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.IElementUpdater;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class RbcUpdater
implements IElementUpdater {
    private final Map<String, String> nameToCalendarMap = new HashMap<String, String>();
    private final Map<String, String> oldRegularCalendarNameToNewName = new HashMap<String, String>();

    public RbcUpdater(Map<CalendarXmlElement, List<String>> uniqueCalendarsMap, Map<XmlElement, List<String>> uniqueRegularCalendarsMap) {
        this.initNamesToXmlElementMap(uniqueCalendarsMap);
        this.initOldRegularCalendarNameToNewName(uniqueRegularCalendarsMap);
    }

    private void initOldRegularCalendarNameToNewName(Map<XmlElement, List<String>> uniqueRegularCalendarsMap) {
        uniqueRegularCalendarsMap.forEach((uniqueRegularCalendar, duplicateRegularCalendarNames) -> duplicateRegularCalendarNames.forEach(duplicateRegularCalendarName -> this.oldRegularCalendarNameToNewName.put((String)duplicateRegularCalendarName, uniqueRegularCalendar.getAttribute("NAME"))));
    }

    @Override
    public void updateElement(XmlElement topLevelElement) {
        List rbcelements = topLevelElement.getDirectchildsElementbyName("RULE_BASED_CALENDAR");
        ArrayList<String> localRbcsForFolder = new ArrayList<String>();
        rbcelements.stream().forEach(rbc -> this.handleRbcForFolder((List<String>)localRbcsForFolder, (XmlElement)rbc));
        this.handleReferences(topLevelElement, localRbcsForFolder);
        List<Element> duplicateRbcs = this.getDuplicateRbcs(rbcelements);
        duplicateRbcs.forEach(duplicateRbc -> {
            if (!localRbcsForFolder.contains(duplicateRbc.getAttribute("NAME"))) {
                topLevelElement.removeChild(new XmlElement(duplicateRbc));
            }
        });
        List subEntitiesElements = topLevelElement.getAllDecnedElementByName(SchedEntity.TYPE.JOB.name());
        subEntitiesElements.addAll(topLevelElement.getAllDecnedElementByName(SchedEntity.TYPE.SUB_FOLDER.name()));
        subEntitiesElements.forEach(subEntity -> {
            this.updateRegularCalendarsForJob((XmlElement)subEntity);
            List EntityRbcs = subEntity.getDirectchildsElementbyName("RULE_BASED_CALENDARS");
            List<Element> duplicateJobRbcs = this.getDuplicateRbcs(EntityRbcs);
            duplicateJobRbcs.forEach(duplicateRbc -> {
                if (!localRbcsForFolder.contains(duplicateRbc.getAttribute("NAME"))) {
                    subEntity.removeChild(new XmlElement(duplicateRbc));
                }
            });
        });
    }

    private void updateRegularCalendarsForJob(XmlElement subEntity) {
        this.updateDaysCal(subEntity);
        this.updateConfCal(subEntity);
        this.updateWeeksCal(subEntity);
    }

    private void updateWeeksCal(XmlElement subEntity) {
        this.updateCal(subEntity, "WEEKSCAL");
    }

    private void updateConfCal(XmlElement subEntity) {
        this.updateCal(subEntity, "CONFCAL");
    }

    private void updateDaysCal(XmlElement subEntity) {
        this.updateCal(subEntity, "DAYSCAL");
    }

    private void updateCal(XmlElement subEntity, String calType) {
        String calName = subEntity.getAttribute(calType);
        if (calName == null || "".equals(calName)) {
            return;
        }
        String newCalendarName = this.getNewCalendarNameFor(calName);
        if (newCalendarName == null || "".equals(newCalendarName)) {
            return;
        }
        subEntity.setAttribute(calType, newCalendarName);
    }

    private String getNewCalendarNameFor(String daysCalName) {
        return this.oldRegularCalendarNameToNewName.get(daysCalName);
    }

    private void handleRbcForFolder(List<String> localRbcsForFolder, XmlElement rbc) {
        if (rbc.hasAttributeWithValue("LEVEL", "N")) {
            localRbcsForFolder.add(rbc.getAttribute("NAME"));
        } else {
            this.changeToUniqueName(rbc);
        }
    }

    private void handleReferences(XmlElement xmlElement, List<String> localRbcsForFolder) {
        List rbcReferences = xmlElement.getAllDecnedElementByName("RULE_BASED_CALENDARS");
        rbcReferences.forEach(reference -> {
            if (!localRbcsForFolder.contains(reference.getAttribute("NAME"))) {
                this.changeToUniqueName((XmlElement)reference);
            }
        });
    }

    private List<Element> getDuplicateRbcs(List<XmlElement> rbcelements) {
        ArrayList uniqueRbcs = new ArrayList();
        ArrayList<Element> forRemove = new ArrayList<Element>();
        rbcelements.forEach(rbc -> {
            Element rbcElement = rbc.getElement();
            boolean isAlreadyExist = this.isRbcExist(uniqueRbcs, rbcElement);
            if (isAlreadyExist) {
                forRemove.add(rbcElement);
            } else {
                uniqueRbcs.add(rbcElement);
            }
        });
        return forRemove;
    }

    private boolean isRbcExist(List<Element> uniqueRbcs, Element rbcElement) {
        boolean isAlreadyExist = false;
        for (Element element : uniqueRbcs) {
            if (!rbcElement.isEqualNode(element)) continue;
            isAlreadyExist = true;
        }
        return isAlreadyExist;
    }

    private void initNamesToXmlElementMap(Map<CalendarXmlElement, List<String>> uniqueCalendarsMap) {
        uniqueCalendarsMap.forEach((calendar, nameList) -> nameList.forEach(name -> this.nameToCalendarMap.put((String)name, calendar.getAttribute("NAME"))));
    }

    private void changeToUniqueName(XmlElement rbc) {
        String originalRbcName;
        String rbcName = originalRbcName = rbc.getAttribute("NAME");
        if (originalRbcName.startsWith("!")) {
            rbcName = rbcName.substring(1);
        }
        if (!this.nameToCalendarMap.containsKey(rbcName) || originalRbcName.equals("*")) {
            return;
        }
        Object desiredRbcName = originalRbcName.startsWith("!") ? "!" + this.nameToCalendarMap.get(rbcName) : this.nameToCalendarMap.get(rbcName);
        rbc.setAttribute("NAME", (String)desiredRbcName);
    }
}

