/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CalendarXmlElement;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CalendarsXmlParser;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.DuplicateRbcException;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UniqueRbcCollector;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UniqueRegularCalendarCollector;
import com.bmc.ctmconvert.common.xml.XmlElement;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class CtmCalendarsHandler {
    private CalendarsXmlParser calendarsParser = new CalendarsXmlParser();
    private UniqueRbcCollector rbcCollector = new UniqueRbcCollector();
    private UniqueRegularCalendarCollector regularCalendarCollector = new UniqueRegularCalendarCollector();

    public void read(InputStream calendarsInputStream) throws DuplicateRbcException {
        this.calendarsParser.parse(calendarsInputStream);
        this.regularCalendarCollector.collect(this.calendarsParser.getRegularCalendars());
        this.updateRbcReferencesToRegularCalendars(this.calendarsParser);
        List<CalendarXmlElement> rbcCalendars = this.calendarsParser.getRuleBasedCalendars();
        this.rbcCollector.collect(rbcCalendars);
    }

    private void updateRbcReferencesToRegularCalendars(CalendarsXmlParser calendarsParser) {
        Map<XmlElement, List<String>> regularCalendarMap = this.regularCalendarCollector.getUniqueCalendarsMap();
        List<CalendarXmlElement> ruleBasedCalendars = calendarsParser.getRuleBasedCalendars();
        ruleBasedCalendars.forEach(calendarXmlElement -> {
            this.updateCalNameIfNeeded(regularCalendarMap, (CalendarXmlElement)((Object)calendarXmlElement), "CONFCAL");
            this.updateCalNameIfNeeded(regularCalendarMap, (CalendarXmlElement)((Object)calendarXmlElement), "DAYSCAL");
            this.updateCalNameIfNeeded(regularCalendarMap, (CalendarXmlElement)((Object)calendarXmlElement), "WEEKSCAL");
            this.updateCalNameIfNeeded(regularCalendarMap, (CalendarXmlElement)((Object)calendarXmlElement), "DAYS");
        });
    }

    private void updateCalNameIfNeeded(Map<XmlElement, List<String>> regularCalendarMap, CalendarXmlElement calendarXmlElement, String typeOfCal) {
        regularCalendarMap.forEach((uniqueCalElement, duplicateCalendarNames) -> {
            if (this.isReferringToDuplicateCalendar(calendarXmlElement, typeOfCal, (List<String>)duplicateCalendarNames)) {
                this.replaceReferenceCalendarName(calendarXmlElement, typeOfCal, (XmlElement)uniqueCalElement);
            }
        });
    }

    private void replaceReferenceCalendarName(CalendarXmlElement calendarXmlElement, String typeOfCal, XmlElement uniqueCalElement) {
        calendarXmlElement.setAttribute(typeOfCal, uniqueCalElement.getAttribute("NAME"));
    }

    private boolean isReferringToDuplicateCalendar(CalendarXmlElement calendarXmlElement, String typeOfCal, List<String> duplicateCalendarNames) {
        return duplicateCalendarNames.contains(this.getCalendarNameOfType(calendarXmlElement, typeOfCal));
    }

    private String getCalendarNameOfType(CalendarXmlElement calendarXmlElement, String typeOfCal) {
        return calendarXmlElement.getAttribute(typeOfCal);
    }

    public CalendarsXmlParser getCalendarsParser() {
        return this.calendarsParser;
    }

    public UniqueRbcCollector getUniqueRbcCollector() {
        return this.rbcCollector;
    }

    public UniqueRegularCalendarCollector getUniqueRegularCalendarCollector() {
        return this.regularCalendarCollector;
    }
}

