/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CronDataReader {
    private Map<String, Integer> machineToJobsMap;
    private Map<String, Map<String, String[]>> machine2userJobs;
    private Map<String, Map<String, String[]>> machineUserVaribles;
    private static String MACHINE_SEPERATOR = "%";
    private BufferedReader br;
    private String datasourcePath;

    public CronDataReader(String datasourcePath) {
        this.datasourcePath = datasourcePath;
        this.machine2userJobs = new HashMap<String, Map<String, String[]>>();
        this.machineUserVaribles = new HashMap<String, Map<String, String[]>>();
        this.machineToJobsMap = new HashMap<String, Integer>();
    }

    public Map<String, Map<String, String[]>> getMachine2userJobs() {
        return this.machine2userJobs;
    }

    public Map<String, Map<String, String[]>> getMachineUserVaribles() {
        return this.machineUserVaribles;
    }

    public Map<String, Integer> getMachineToJobsMap() {
        return this.machineToJobsMap;
    }

    public void parseCronData() {
        File cronDir = new File(this.datasourcePath);
        HashMap<String, String[]> users = null;
        HashMap<String, String[]> usersOfVars = null;
        try {
            File[] files = cronDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().contains(MACHINE_SEPERATOR)) continue;
                String machineName = this.getMachineNameFromFileName(files[i].getName());
                users = this.initUserList(users, files[i], machineName);
                usersOfVars = this.initUserVarList(usersOfVars, files[i], machineName);
                if (this.machine2userJobs.get(machineName) != null) {
                    users.putAll(this.machine2userJobs.get(machineName));
                }
                this.machine2userJobs.put(machineName, users);
                if (this.machineUserVaribles.get(machineName) != null) {
                    usersOfVars.putAll(this.machineUserVaribles.get(machineName));
                }
                this.machineUserVaribles.put(machineName, usersOfVars);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private HashMap<String, String[]> initUserVarList(HashMap<String, String[]> users, File cronFile, String machineName) {
        users = new HashMap();
        String[] VarArr = this.initVars(cronFile);
        String userName = this.getUserNameFromFileName(cronFile.getName());
        users.put(userName, VarArr);
        return users;
    }

    private HashMap<String, String[]> initUserList(HashMap<String, String[]> users, File cronFile, String machineName) {
        users = new HashMap();
        String[] jobArr = this.initJobs(cronFile);
        String userName = this.getUserNameFromFileName(cronFile.getName());
        users.put(userName, jobArr);
        this.appendNumberOfjobs(machineName, jobArr.length);
        this.appendNumberOfjobs(userName, jobArr.length);
        return users;
    }

    private String[] initVars(File cronFile) {
        ArrayList<String> vars = new ArrayList<String>();
        try {
            String line;
            this.br = new BufferedReader(new FileReader(cronFile));
            while ((line = this.br.readLine()) != null) {
                line = line.replaceAll("([^\\{0,1}](#.*)$)|((#.*)$)", "");
                if ((line = line.trim()).matches("^[0-9].*") || line.startsWith("*") || line.startsWith("@")) {
                    line = "";
                }
                if (!line.matches("^.*=.*$")) continue;
                vars.add(line);
            }
            this.br.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        String[] ret = new String[vars.size()];
        ret = vars.toArray(ret);
        return ret;
    }

    private String[] initJobs(File cronFile) {
        ArrayList<String> jobs = new ArrayList<String>();
        try {
            String line;
            this.br = new BufferedReader(new FileReader(cronFile));
            while ((line = this.br.readLine()) != null) {
                line = line.replaceAll("([^\\{0,1}](#.*)$)|((#.*)$)", "");
                if ((line = line.trim()).matches("^[A-Za-z].*")) {
                    line = "";
                }
                if (line.startsWith("@")) {
                    line = this.parseKeyWords(line);
                }
                if (line.isEmpty()) continue;
                jobs.add(line);
            }
            this.br.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        String[] ret = new String[jobs.size()];
        ret = jobs.toArray(ret);
        return ret;
    }

    private void appendNumberOfjobs(String name, int num) {
        int val = this.machineToJobsMap.get(name) == null ? 0 : this.machineToJobsMap.get(name);
        this.machineToJobsMap.put(name, val + num);
    }

    private String parseKeyWords(String line) {
        line = line.replaceFirst("@reboot", "* * * * * ");
        line = line.replaceFirst("@yearly", "0 0 1 1 * ");
        line = line.replaceFirst("@monthly", "0 0 1 * * ");
        line = line.replaceFirst("@weekly", "0 0 * * 0 ");
        line = line.replaceFirst("@daily", "0 0 * * * ");
        line = line.replaceFirst("@hourly", "0 * * * * ");
        return line;
    }

    private String getUserNameFromFileName(String fileName) {
        return fileName.substring(0, fileName.indexOf(MACHINE_SEPERATOR));
    }

    private String getMachineNameFromFileName(String fileName) {
        String name = fileName.substring(fileName.indexOf(MACHINE_SEPERATOR) + 1);
        if (name.contains(".")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }
}

