/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.modes;

import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.modes.LogicalSplitMode;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\r\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/bmc/ctmconvert/modes/Mode;", "T", "", "arguments", "Lcom/bmc/ctmconvert/Arguments;", "<init>", "(Lcom/bmc/ctmconvert/Arguments;)V", "getArguments", "()Lcom/bmc/ctmconvert/Arguments;", "run", "()Ljava/lang/Object;", "printInputParameters", "", "internalRun", "clearOutputDirectoryIfTrueArgument", "splitLargeFolder"})
public abstract class Mode<T> {
    @NotNull
    private final Arguments arguments;

    public Mode(@NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.arguments = arguments;
    }

    @NotNull
    protected Arguments getArguments() {
        return this.arguments;
    }

    public final T run() {
        this.printInputParameters();
        this.clearOutputDirectoryIfTrueArgument(this.getArguments());
        return this.internalRun();
    }

    private final void printInputParameters() {
        if (this instanceof LogicalSplitMode) {
            String string = StringsKt.trimMargin$default((String)("Input Parameters: \n                |output dir: " + ((Object)this.getArguments().getOutputDirectory().toAbsolutePath()).toString() + "\n                |min (any flow below this will be added to the singles folder): " + this.getArguments().getMinJobsInFolder() + " \n                |max: " + this.getArguments().getMaxJobsInFolder() + "\n                |-----------------------------\n            "), null, (int)1, null);
            System.out.println((Object)string);
        }
    }

    protected abstract T internalRun();

    protected final void clearOutputDirectoryIfTrueArgument(@NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (arguments.getClearOutputDirectory()) {
            PathsKt.deleteRecursively((Path)arguments.getOutputDirectory());
        }
    }
}

