/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tester;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.tester.RuleTester;
import com.bmc.ctmconvert.tester.RuleTesterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class ConditionTester
implements RuleTester {
    private JSONObject responseJson;
    private String entityNameArgument;
    private String conditionArgument;
    private RuleTesterFactory.ConditionType condType;

    public ConditionTester(JSONObject responseJson, String entityNameArgument, String conditionArgument, RuleTesterFactory.ConditionType condType) {
        this.responseJson = responseJson;
        this.entityNameArgument = entityNameArgument;
        this.conditionArgument = conditionArgument;
        this.condType = condType;
    }

    @Override
    public void test() throws ConversionException {
        List createdJobs = Context.getWorkspace().getAllJobs();
        List<CtmBaseEntity> jobs = createdJobs.stream().filter(job -> job.getName().trim().equals(this.entityNameArgument.trim())).collect(Collectors.toList());
        List createdFolders = Context.getWorkspace().getAllFolders();
        List<CtmBaseEntity> folders = createdFolders.stream().filter(folder -> folder.getName().trim().equals(this.entityNameArgument.trim())).collect(Collectors.toList());
        if (!this.isConditionExistInOneOFTheEntities(jobs) && !this.isConditionExistInOneOFTheEntities(folders)) {
            throw new ConversionException("When running '{{conditionType}}' rule, '{{conditionType}}' with name '" + this.conditionArgument + "' was not created for entity name '" + this.entityNameArgument + "'.\r\n");
        }
        this.responseJson.put("message", (Object)("When running '{{conditionType}}' rule, '{{conditionType}}' with name '" + this.conditionArgument + "' was created for entity name '" + this.entityNameArgument + "'.\r\n"));
    }

    private boolean isConditionExistInOneOFTheEntities(List<CtmBaseEntity> jobs) {
        return jobs.stream().anyMatch(job -> this.getConditions((CtmBaseEntity)job).stream().anyMatch(conditionName -> conditionName.equals(this.conditionArgument.trim())));
    }

    private List<String> getConditions(CtmBaseEntity job) {
        if (this.condType.equals((Object)RuleTesterFactory.ConditionType.INCOND)) {
            return job.getInConditions().stream().map(condition -> condition.getName()).collect(Collectors.toList());
        }
        if (this.condType.equals((Object)RuleTesterFactory.ConditionType.OUTCOND)) {
            return job.getOutConditions().stream().map(condition -> condition.getName()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

