/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.exception.ScriptRuleException;
import com.bmc.ctmconvert.rule.ScriptRule;
import groovy.lang.GroovyShell;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.json.JSONArray;
import org.json.JSONObject;

public class RuleCompilationTester {
    private CompilerConfiguration prepareGroovyShellConfiguration() {
        CompilerConfiguration config = new CompilerConfiguration();
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addImports(ScriptRule.getImportsForScript());
        importCustomizer.addStarImports(ScriptRule.getStarImportsForScript());
        config.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        return config;
    }

    private String returnNewLines(String script) {
        Pattern pattern = Pattern.compile("[^\n]*?\n");
        Matcher matcher = pattern.matcher(script);
        Object ret = "\n";
        while (matcher.find()) {
            ret = (String)ret + "\n";
        }
        return ret;
    }

    void testRulesCompilation(JSONArray rulesJsonArray) throws ScriptRuleException {
        Object newLines = "";
        for (JSONObject ruleJsonObject : rulesJsonArray) {
            JSONObject rulesData = ruleJsonObject.getJSONObject("rulesData");
            String rulesname = ruleJsonObject.getString("name");
            String script = rulesData.getString("script");
            CompilerConfiguration config = this.prepareGroovyShellConfiguration();
            GroovyShell shell = new GroovyShell(config);
            try {
                Object scriptToRun = "";
                scriptToRun = (String)newLines + script;
                shell.parse((String)scriptToRun);
                newLines = (String)newLines + this.returnNewLines(script);
            }
            catch (RuntimeException e) {
                throw new ScriptRuleException("Error in Script Rule syntax, please fix the relevant script syntax.", e, "'" + rulesname + "' rule ");
            }
        }
    }
}

