/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.builderutils.BuilderUtils;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class GetFileContentServlet
extends HttpServlet {
    private static final long serialVersionUID = 6306088768444594588L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        JSONObject responseJsonObject = new JSONObject();
        try {
            String projectName = req.getParameter("projectName");
            String fileName = req.getParameter("fileName");
            String projectFullDataPath = String.format(Globs.SELF_CONVERSION_DATA_DIR_PATTERN, projectName) + Globs.DIRSEP + fileName;
            String dataFileContent = this.readFileContentToString(projectFullDataPath);
            responseJsonObject.put("status", (Object)"success");
            responseJsonObject.put("fileContentString", (Object)dataFileContent);
        }
        catch (ConversionException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            responseJsonObject.put("status", (Object)"failure");
            responseJsonObject.put("reason", (Object)("failed to get input file content -\r\n" + e.getMessage()));
        }
        finally {
            resp.getWriter().println(responseJsonObject.toString());
        }
    }

    private String readFileContentToString(String fullPathStringToFile) throws ConversionException {
        StringBuilder result = new StringBuilder();
        try {
            Path pathToFile = BuilderUtils.getFileFromPath(fullPathStringToFile);
            try (BufferedReader br = Files.newBufferedReader(pathToFile);){
                String line;
                while ((line = br.readLine()) != null) {
                    result.append(line + "\r\n");
                }
            }
        }
        catch (IOException e) {
            throw new ConversionException("failed reading input file content -\r\n" + e.getMessage());
        }
        return result.toString();
    }
}

