/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.SelfConversionRepositoryManager;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class EditProjectServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SelfConversionRepositoryManager selfConversionRepositoryManager = SelfConversionRepositoryManager.getRepositoryManager();
        JSONObject responseJsonObject = new JSONObject();
        try {
            ServletInputStream requestAsInputStream = request.getInputStream();
            String requestBodyJsonString = IOUtils.toString((InputStream)requestAsInputStream);
            JSONObject requestBodyJson = new JSONObject(requestBodyJsonString);
            String projectName = requestBodyJson.getString("projectName");
            JSONObject projectJsonObject = selfConversionRepositoryManager.getProjectByName(projectName);
            JSONObject newProjectJsonObject = new JSONObject(projectJsonObject.toString());
            if (requestBodyJson.has("newProjectVendor")) {
                newProjectJsonObject.put("projectSourceVendorName", (Object)requestBodyJson.getString("newProjectVendor"));
            }
            if (requestBodyJson.has("newProjectDescription")) {
                newProjectJsonObject.put("projectDescription", (Object)requestBodyJson.getString("newProjectDescription"));
            }
            if (requestBodyJson.has("newProjectTargetCTMVersion")) {
                newProjectJsonObject.put("projectTargetCTMVersion", (Object)requestBodyJson.getString("newProjectTargetCTMVersion"));
            }
            if (requestBodyJson.has("newProjectName")) {
                newProjectJsonObject.put("projectName", (Object)requestBodyJson.getString("newProjectName"));
            }
            if (requestBodyJson.has("inputFiles")) {
                selfConversionRepositoryManager.addFileToProject(projectName, requestBodyJson.getJSONArray("inputFiles"), responseJsonObject);
            }
            selfConversionRepositoryManager.editProject(projectJsonObject.getString("projectName"), newProjectJsonObject);
            responseJsonObject.put("editStatus", (Object)"success");
            responseJsonObject.put("editProjectData", (Object)newProjectJsonObject);
        }
        catch (ConversionException ce) {
            responseJsonObject.put("editStatus", (Object)"failure");
            responseJsonObject.put("reason", (Object)ce.getMessage());
        }
        catch (JSONException je) {
            responseJsonObject.put("editStatus", (Object)"failure");
            responseJsonObject.put("reason", (Object)("failed to save edit project - " + je.getMessage()));
        }
        finally {
            response.getWriter().println(responseJsonObject.toString());
        }
    }
}

