/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.ProjectDuplicator;
import com.bmc.ctmconvert.SelfConversionRepositoryManager;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

public class DuplicateProjectServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SelfConversionRepositoryManager selfConversionRepositoryManager = SelfConversionRepositoryManager.getRepositoryManager();
        JSONObject responseJsonObject = new JSONObject();
        String targetProjectName = "";
        try {
            ServletInputStream requestAsInputStream = request.getInputStream();
            String requestBodyJsonString = IOUtils.toString((InputStream)requestAsInputStream);
            JSONObject requestJsonObject = new JSONObject(requestBodyJsonString);
            targetProjectName = requestJsonObject.getString("targetProjectName");
            ProjectDuplicator duplicator = new ProjectDuplicator(FileSystems.getDefault(), selfConversionRepositoryManager);
            duplicator.duplicateProject(requestJsonObject);
            responseJsonObject.put("status", (Object)"success");
        }
        catch (ConversionException e) {
            try {
                selfConversionRepositoryManager.revertProjectFileStructure(targetProjectName);
            }
            catch (ConversionException ce) {
                ExceptionHandler.writeToExceptionFile((Exception)((Object)ce));
            }
            finally {
                responseJsonObject.put("status", (Object)"failure");
                responseJsonObject.put("reason", (Object)e.getMessage());
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            }
        }
        finally {
            response.getWriter().println(responseJsonObject.toString());
        }
    }
}

