/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare.xml_compare_tool;

import com.bmc.toolbox.compare.xml_compare.changes.XmlChange;
import com.bmc.toolbox.utils.Counter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NodesCounter {
    private HashMap<Pair, Counter> nodesStatistic = new HashMap();

    public void handleChange(XmlChange change) {
        XmlChange.Action action;
        String name = change.getName();
        Pair pair = new Pair(name, action = change.getAction());
        if (!this.nodesStatistic.containsKey(pair)) {
            this.nodesStatistic.put(pair, new Counter());
        }
        Counter counter = this.nodesStatistic.get(pair);
        counter.clack();
    }

    public List<String> getChangesName() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Pair node : this.nodesStatistic.keySet()) {
            String name = node.getName();
            if (ret.contains(name)) continue;
            ret.add(name);
        }
        return ret;
    }

    public int getNumberOfChanges(String name, XmlChange.Action action) {
        Pair node = new Pair(name, action);
        if (!this.nodesStatistic.containsKey(node)) {
            return 0;
        }
        Counter counter = this.nodesStatistic.get(node);
        return counter.toInt();
    }

    public String getStatisticStringNodes() {
        StringBuilder attributesString = new StringBuilder();
        List<String> names = this.getChangesName();
        attributesString.append("Number of attributes changed:" + names.size()).append("\n");
        attributesString.append("Attribute           Action              Count \n");
        attributesString.append("==================================================\n");
        for (String name : names) {
            for (XmlChange.Action action : XmlChange.Action.values()) {
                int changeAmount = this.getNumberOfChanges(name, action);
                String line = this.getLine(name, action, changeAmount);
                if (changeAmount <= 0) continue;
                attributesString.append(line + "\n");
            }
        }
        return attributesString.toString();
    }

    private String getLine(String name, XmlChange.Action action, int changeAmount) {
        String line = String.format("%-20s%-20s%-10s", new Object[]{name, action, changeAmount});
        return line;
    }

    public class Pair {
        private XmlChange.Action action;
        private String name;

        public String toString() {
            return "Pair [action=" + String.valueOf((Object)this.action) + ", name=" + this.name + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.action == null ? other.action != null : !this.action.equals((Object)other.action)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public Pair(String name, XmlChange.Action action) {
            this.name = name;
            this.action = action;
        }

        public XmlChange.Action getAction() {
            return this.action;
        }

        public String getName() {
            return this.name;
        }

        private NodesCounter getOuterType() {
            return NodesCounter.this;
        }
    }
}

