/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.csv_compare;

public class CsvChange {
    private ChangeType changeType;
    private Integer oldRowIndex;
    private Integer newRowIndex;
    private String oldValue;
    private String newValue;

    public CsvChange(ChangeType type, Integer oldIndex, Integer newIndex) {
        this.changeType = type;
        this.oldRowIndex = oldIndex;
        this.newRowIndex = newIndex;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public Integer getOldRowIndex() {
        return this.oldRowIndex;
    }

    public Integer getNewRowIndex() {
        return this.newRowIndex;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public String getKeyForTypeChange() {
        String toRet = null;
        if (this.getChangeType() == ChangeType.IN_VALUE) {
            toRet = this.getNewValue().split("=")[0];
        }
        return toRet;
    }

    public String toString() {
        String toRet = "";
        String newOld = this.newValue == null ? "Removed" : "Added";
        String value = newOld.equals("Added") ? this.newValue : this.oldValue;
        switch (this.changeType.ordinal()) {
            case 1: {
                int idx = newOld.equals("Added") ? this.newRowIndex : this.oldRowIndex;
                toRet = String.format("%s row at index %d: %s", newOld, idx, value);
                break;
            }
            case 0: {
                toRet = String.format("%s column: %s", newOld, value);
                break;
            }
            case 2: {
                toRet = String.format("Value at lines %d/%d changed from '%s' to' %s'", this.oldRowIndex, this.newRowIndex, this.oldValue, this.newValue);
                break;
            }
        }
        return toRet;
    }

    public static enum ChangeType {
        COLUMN,
        ROW,
        IN_VALUE;

    }
}

