/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.csv_compare;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

public class ComparedTable {
    private CsvReader reader;
    private HashSet<String> keys;
    private HashSet<String> ignored;
    private ArrayList<String> header;
    private ArrayList<LinkedHashMap<String, String>> allRecords = new ArrayList();
    private LinkedHashMap<HashSet<String>, ArrayList<Integer>> keyIndex = new LinkedHashMap();

    public ComparedTable(CsvReader csvReader) throws IOException {
        this.reader = csvReader;
        this.reader.readHeaders();
        this.ignored = new HashSet();
        this.keys = new HashSet();
        this.header = new ArrayList();
        this.header.addAll(Arrays.asList(this.reader.getHeaders()));
    }

    public ArrayList<String> getHeader() {
        return this.header;
    }

    public void addIgnoredColumn(String column) {
        this.ignored.add(column);
    }

    public void addKey(String colName) {
        this.keys.add(colName);
    }

    public void loadTable() throws IOException {
        Integer currLine = 0;
        while (this.reader.readRecord()) {
            LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
            for (String column : this.header) {
                if (this.ignored.contains(column)) continue;
                record.put(column, this.reader.get(column));
            }
            this.allRecords.add(record);
            if (!this.keys.isEmpty()) {
                HashSet<String> toIndex = this.keysToSet(record);
                if (!this.keyIndex.containsKey(toIndex)) {
                    this.keyIndex.put(toIndex, new ArrayList());
                }
                this.keyIndex.get(toIndex).add(currLine);
            }
            Integer n = currLine;
            currLine = currLine + 1;
        }
    }

    public HashSet<String> keysToSet(HashMap<String, String> record) {
        HashSet<String> toRet = new HashSet<String>();
        for (String key : this.keys) {
            toRet.add(String.format("%s=%s", key, record.get(key)));
        }
        return toRet;
    }

    public HashMap<String, String> getRecordByIndex(int index) {
        HashMap toRet = null;
        if (index < this.allRecords.size()) {
            toRet = this.allRecords.get(index);
        }
        return toRet;
    }

    public Integer getRecordIndexByKey(HashSet<String> key) {
        return this.getRecordIndexByKeyWithMin(key, 0);
    }

    public Integer getRecordIndexByKeyWithMin(HashSet<String> key, int minIndex) {
        Integer toRet = -1;
        if (this.keyIndex.containsKey(key)) {
            for (Integer candidate : this.keyIndex.get(key)) {
                if (candidate < minIndex) continue;
                toRet = candidate;
                break;
            }
        }
        return toRet;
    }

    public HashMap<String, String> getRecordByKey(HashSet<String> key) {
        int recordIdx = this.getRecordIndexByKey(key);
        return recordIdx >= 0 ? this.getRecordByIndex(recordIdx) : null;
    }

    public int findIdenticalRecordIndexStartingFrom(HashMap<String, String> toTest, int startIdx) {
        int toRet = -1;
        for (int i = startIdx; i < this.allRecords.size() && toRet < 0; ++i) {
            if (!toTest.equals(this.allRecords.get(i))) continue;
            toRet = i;
        }
        return toRet;
    }

    public int findIdenticalRecordIndex(HashMap<String, String> toTest) {
        return this.findIdenticalRecordIndexStartingFrom(toTest, 0);
    }

    public int getRecordCount() {
        return this.allRecords.size();
    }
}

