/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.csv_compare;

import com.bmc.toolbox.compare.csv_compare.ActionsList;
import com.bmc.toolbox.compare.csv_compare.ActionsReader;
import com.bmc.toolbox.compare.csv_compare.CountChange;
import com.bmc.toolbox.compare.csv_compare.IActionChangeHandler;
import com.bmc.toolbox.compare.csv_compare.OnlyOneChange;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActionsComperator {
    private IActionChangeHandler changeHandler;

    public ActionsComperator(IActionChangeHandler changeHandler2) {
        this.changeHandler = changeHandler2;
    }

    public void compare(InputStream action1, InputStream action2) {
        ActionsReader actionsReader = new ActionsReader();
        Map<String, ActionsList> action1Actions = actionsReader.readActions(action1);
        Map<String, ActionsList> action2Actions = actionsReader.readActions(action2);
        for (String action : action1Actions.keySet()) {
            if (!action2Actions.containsKey(action)) {
                this.changeHandler.handleActionOnlyOnFirstChange(action);
                continue;
            }
            ActionsList actions1 = action1Actions.get(action);
            ActionsList actions2 = action2Actions.get(action);
            List<String> actionsNames1 = actions1.getNames();
            List<String> actionsNames2 = actions2.getNames();
            List<String> sharedNames = this.getUnion(actionsNames1, actionsNames2);
            List<String> onlyOnFirst = this.removeFromList(actionsNames1, sharedNames);
            List<String> onlyOnSecond = this.removeFromList(actionsNames2, sharedNames);
            for (String name : sharedNames) {
                int count2;
                int count1 = actions1.getActionNameOcurences(name);
                if (count1 == (count2 = actions2.getActionNameOcurences(name))) continue;
                CountChange change = new CountChange(action, name, count1, count2);
                this.changeHandler.handleActionCountChanged(change);
            }
            for (String actionName : onlyOnFirst) {
                OnlyOneChange change = new OnlyOneChange(action, actionName, actions1.getActionNameOcurences(actionName));
                this.changeHandler.handleNameOnlyOnFirstChanged(change);
            }
            for (String actionName : onlyOnSecond) {
                OnlyOneChange change = new OnlyOneChange(action, actionName, actions2.getActionNameOcurences(actionName));
                this.changeHandler.handleNameOnlyOnSecondChanged(change);
            }
        }
        for (String action : action2Actions.keySet()) {
            if (action1Actions.containsKey(action)) continue;
            this.changeHandler.handleActionOnlyOnSecondChange(action);
        }
    }

    private List<String> removeFromList(List<String> actionsNames1, List<String> sharedNames) {
        ArrayList<String> tmp = new ArrayList<String>(actionsNames1);
        tmp.removeAll(sharedNames);
        return tmp;
    }

    private List<String> getUnion(List<String> actionsNames1, List<String> actionsNames2) {
        ArrayList<String> tmp = new ArrayList<String>(actionsNames1);
        tmp.retainAll(actionsNames2);
        return tmp;
    }
}

