/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.gui;

import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.EntitisMatcher;
import com.bmc.toolbox.compare.condition_compare.entitesCounter.SimpleDraftReader;
import com.bmc.toolbox.compare.condition_compare.gui.RbcChangeHandler;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

public class RbcComperator {
    private RbcChangeHandler changeHandler;

    public RbcComperator(RbcChangeHandler changeHandler2) {
        this.changeHandler = changeHandler2;
    }

    public void compare(InputStream inA, InputStream inB) {
        List<DraftEntityImp> entites1 = SimpleDraftReader.getEntities(inA);
        List<DraftEntityImp> entites2 = SimpleDraftReader.getEntities(inB);
        EntitisMatcher matcher = new EntitisMatcher(entites1, entites2);
        List<DraftPath> shared = matcher.getSharedEntites();
        for (DraftPath draftPath : shared) {
            DraftEntityImp first = matcher.getFirst(draftPath);
            DraftEntityImp second = matcher.getSecond(draftPath);
            Set<String> rbcs1 = first.getRbcs();
            Set<String> rbcs2 = second.getRbcs();
            for (String rbc : rbcs1) {
                if (rbcs2.contains(rbc)) continue;
                this.changeHandler.addRbcOnlyOn1Change(draftPath, rbc);
            }
            for (String rbc : rbcs2) {
                if (rbcs1.contains(rbc)) continue;
                this.changeHandler.addRbcOnlyOn2Change(draftPath, rbc);
            }
        }
    }
}

