/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.draftReader;

import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.ValueGetter;
import com.bmc.toolbox.compare.condition_compare.draftReader.DraftEntitiesReader;
import com.bmc.toolbox.compare.condition_compare.draftReader.EntitesCreator;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderFactory;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderUtils;
import com.bmc.toolbox.compare.condition_compare.draftReader.SchedEntitesHandler;
import com.bmc.toolbox.compare.condition_compare.draftReader.SubEntityReader;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.entitites.SubFolder;
import com.bmc.toolbox.compare.condition_compare.predicates.EndOfSubFolderPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfSubFolderPredicate;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class SubFolderReader {
    private SchedEntitesHandler handler;
    private DraftPath parent;
    private EntitesCreator entitesCreator;

    public SubFolderReader(SchedEntitesHandler handler2, DraftPath parent) {
        this.handler = handler2;
        this.parent = parent;
        this.entitesCreator = new EntitesCreator();
    }

    public void readSubFolder(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent subFolderEvent = eventReader.nextEvent();
        if (this.isStartOfSubFolder(subFolderEvent)) {
            List<MyAttribute> attributes = ReaderUtils.getEventAttributes(subFolderEvent);
            String subFolderName = this.getName(attributes);
            DraftPath subFolderPath = new DraftPath(subFolderName, this.parent);
            SubFolder subFolder = this.entitesCreator.createSubFolder(subFolderEvent, subFolderPath);
            this.handler.handleSubFolder(subFolder);
            ReaderFactory factory = new ReaderFactory();
            List<DraftEntitiesReader> readers = factory.getReaders(subFolder);
            while (eventReader.hasNext()) {
                for (DraftEntitiesReader reader : readers) {
                    reader.read(eventReader);
                }
                XMLEvent event = eventReader.peek();
                SubEntityReader subEntityHandler = new SubEntityReader(this.handler, subFolderPath);
                subEntityHandler.readSubEntity(event, eventReader);
                event = eventReader.nextEvent();
                if (!this.isEndOfSubFolderEvent(event)) continue;
                break;
            }
        }
    }

    private boolean isStartOfSubFolder(XMLEvent event) {
        StartOfSubFolderPredicate startOfJobPredicate = new StartOfSubFolderPredicate();
        return startOfJobPredicate.test(event);
    }

    private boolean isEndOfSubFolderEvent(XMLEvent event) {
        EndOfSubFolderPredicate endOfSmartPredicate = new EndOfSubFolderPredicate();
        return endOfSmartPredicate.test(event);
    }

    private String getName(List<MyAttribute> myAttributes) {
        ValueGetter nameGetter = new ValueGetter("JOBNAME");
        String smartFolderName = nameGetter.fromList(myAttributes);
        if (smartFolderName == null || smartFolderName.isEmpty()) {
            nameGetter = new ValueGetter("MEMNAME");
            smartFolderName = nameGetter.fromList(myAttributes);
        }
        return smartFolderName;
    }
}

