/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare;

import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EntitisMatcher {
    private List<DraftEntityImp> entites1;
    private Map<DraftPath, DraftEntityImp> entites2Map;
    private Map<DraftPath, DraftEntityImp> entites1Map;

    public EntitisMatcher(List<DraftEntityImp> entites1, List<DraftEntityImp> entites2) {
        this.entites1 = entites1;
        this.entites2Map = this.map(entites2);
        this.entites1Map = this.map(entites1);
    }

    public List<DraftPath> getSharedEntites() {
        Predicate<DraftPath> onlyWith2Predicate = path -> this.entites2Map.containsKey(path);
        List<DraftPath> shared = this.entites1.stream().map((? super T entity) -> entity.getPath()).filter(onlyWith2Predicate).collect(Collectors.toList());
        return shared;
    }

    private Map<DraftPath, DraftEntityImp> map(List<DraftEntityImp> entites1) {
        HashMap<DraftPath, DraftEntityImp> entites1Map = new HashMap<DraftPath, DraftEntityImp>();
        for (DraftEntityImp draftEntityImp : entites1) {
            DraftPath path = draftEntityImp.getPath();
            entites1Map.put(path, draftEntityImp);
        }
        return entites1Map;
    }

    public boolean isOnSecond(DraftEntityImp entity) {
        DraftPath path = entity.getPath();
        return this.entites2Map.containsKey(path);
    }

    public boolean isOnFirst(DraftEntityImp entity) {
        DraftPath path = entity.getPath();
        return this.entites1Map.containsKey(path);
    }

    public DraftEntityImp getFirst(DraftPath path) {
        return this.entites1Map.get(path);
    }

    public DraftEntityImp getSecond(DraftPath path) {
        return this.entites2Map.get(path);
    }
}

