/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare;

import com.bmc.toolbox.compare.condition_compare.DependencyChanghHandler;
import com.bmc.toolbox.compare.condition_compare.DependencyFinder;
import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.EntitisMatcher;
import com.bmc.toolbox.compare.condition_compare.entitesCounter.SimpleDraftReader;
import com.bmc.toolbox.compare.condition_compare.entitites.Dependency;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ConditionComperator {
    private DependencyChanghHandler changeHandler;

    public ConditionComperator(DependencyChanghHandler changeHandler2) {
        this.changeHandler = changeHandler2;
    }

    public void compare(InputStream inA, InputStream inB) throws IOException {
        List<DraftEntityImp> entites1 = SimpleDraftReader.getEntities(inA);
        List<DraftEntityImp> entites2 = SimpleDraftReader.getEntities(inB);
        this.compare(entites1, entites2);
    }

    public void compare(List<DraftEntityImp> entites1, List<DraftEntityImp> entites2) {
        this.checkEntites(entites1, entites2);
    }

    private void checkEntites(List<DraftEntityImp> entites1, List<DraftEntityImp> entites2) {
        DependencyFinder entites1Finder = new DependencyFinder(entites1);
        DependencyFinder entites2Finder = new DependencyFinder(entites2);
        EntitisMatcher entitisMatcher = new EntitisMatcher(entites1, entites2);
        List<DraftPath> sharedEntites = entitisMatcher.getSharedEntites();
        for (DraftPath conditionSenderPath : sharedEntites) {
            List<DraftEntityImp> conditionGettersOnlyOnSecond;
            List<DraftEntityImp> entity2Dependencies;
            List<DraftEntityImp> entity1Dependencies = entites1Finder.getEntityDependencies(conditionSenderPath);
            List<DraftEntityImp> conditionGettersOnlyOnFirst = this.removeList(entity1Dependencies, entity2Dependencies = entites2Finder.getEntityDependencies(conditionSenderPath));
            if (!conditionGettersOnlyOnFirst.isEmpty()) {
                for (DraftEntityImp conditionGetter : conditionGettersOnlyOnFirst) {
                    Dependency dependency = new Dependency(conditionGetter, entitisMatcher.getFirst(conditionSenderPath));
                    this.changeHandler.addExistOnlyInFirstEvent(dependency);
                }
            }
            if ((conditionGettersOnlyOnSecond = this.removeList(entity2Dependencies, entity1Dependencies)).isEmpty()) continue;
            for (DraftEntityImp conditionGetter : conditionGettersOnlyOnSecond) {
                Dependency dependency = new Dependency(conditionGetter, entitisMatcher.getSecond(conditionSenderPath));
                this.changeHandler.addExistOnlyInSecondEvent(dependency);
            }
        }
    }

    private List<DraftEntityImp> removeList(List<DraftEntityImp> entity1Dependencies, List<DraftEntityImp> entity2Dependencies) {
        ArrayList<DraftEntityImp> entity1DependenciesRemoved = new ArrayList<DraftEntityImp>(entity1Dependencies);
        entity1DependenciesRemoved.removeAll(entity2Dependencies);
        return entity1DependenciesRemoved;
    }
}

