/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox;

import com.bmc.toolbox.CD_DataAnalysis.DataAnalysis;
import com.bmc.toolbox.CLIRunner;
import com.bmc.toolbox.CopyConversionResults.CopyAllConversionResultsFolders;
import com.bmc.toolbox.ToolBoxCLIEntity;
import com.bmc.toolbox.compare.csv_compare.CSVComparisonExecutor;
import com.bmc.toolbox.compare.properties_compare.ComparePropertiesFiles;
import com.bmc.toolbox.compare.xml_compare.CalendarComparator;
import com.bmc.toolbox.compare.xml_compare.DraftComparator;
import com.bmc.toolbox.compare.xml_compare.xml_compare_tool.XMLCompareTool;
import com.bmc.toolbox.xml_json_compare.JsonXmlCompareTool;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class ToolBox {
    public static final String USAGE = "\nUsage:\nToolBox <TOOL NAME> [TOOL ARGS]";
    private static int RC = 0;
    private static ToolBoxCLIEntity compareToolChosed = null;

    public static void main(String[] args) {
        Runnable tool = null;
        if (args.length == 0) {
            System.out.println("no tool specified\nUsage:\nToolBox <TOOL NAME> [TOOL ARGS]");
            System.exit(1);
        }
        String command = args[0];
        String[] actualArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (command.toUpperCase()) {
            case "CD_DATA_ANALYSIS": {
                compareToolChosed = new DataAnalysis();
                tool = new CLIRunner(compareToolChosed, actualArgs);
                break;
            }
            case "DRAFT_XML_COMPARE": {
                List<String> ignoreAttributes = ToolBox.getIgnoreAttributesFrom(actualArgs);
                compareToolChosed = new XMLCompareTool(actualArgs, new DraftComparator(ignoreAttributes));
                tool = new CLIRunner(compareToolChosed, actualArgs);
                break;
            }
            case "CALENDAR_XML_COMPARE": {
                compareToolChosed = new XMLCompareTool(actualArgs, new CalendarComparator());
                tool = new CLIRunner(compareToolChosed, actualArgs);
                break;
            }
            case "PROPERTY_COMPARE": {
                compareToolChosed = new ComparePropertiesFiles();
                tool = new CLIRunner(compareToolChosed, actualArgs);
                break;
            }
            case "CSV_COMPARE": {
                compareToolChosed = new CSVComparisonExecutor();
                tool = new CLIRunner(compareToolChosed, actualArgs);
                break;
            }
            case "COPY_RESULTS_FILES": {
                compareToolChosed = new CopyAllConversionResultsFolders();
                tool = new CLIRunner(compareToolChosed, actualArgs);
                break;
            }
            case "JSON_XML_COMPARE": {
                compareToolChosed = new JsonXmlCompareTool();
                tool = new CLIRunner(compareToolChosed, actualArgs);
                break;
            }
            default: {
                System.out.println(command + " is not a known tool\nUsage:\nToolBox <TOOL NAME> [TOOL ARGS]");
                System.exit(RC);
            }
        }
        tool.run();
    }

    private static List<String> getIgnoreAttributesFrom(String[] actualArgs) {
        return Stream.of(actualArgs).dropWhile(arg1 -> !arg1.equals("-ignore_xml_attributes")).skip(1L).map(arg -> List.of(arg.split(","))).findFirst().orElse(Collections.emptyList());
    }

    public static ToolBoxCLIEntity getCompareToolChosed() {
        return compareToolChosed;
    }
}

