/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.CopyConversionResults;

import com.bmc.toolbox.ToolBoxCLIEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CopyAllConversionResultsFolders
implements ToolBoxCLIEntity {
    private File locationToSave;
    private File conversionDir;
    private List<String> StdOut = new ArrayList<String>();
    private String folderToCopy = "CONVERSIONS";
    private String errorMessage;
    private int RC = 0;
    private static final int ERR = -1;

    public void copydAllConversionsFolders(File f) {
        if (f.getName().trim().equalsIgnoreCase(this.folderToCopy)) {
            try {
                this.copyFolder(f, this.locationToSave);
            }
            catch (IOException e) {
                this.StdOut.add(e.getMessage());
                this.RC = -1;
            }
        } else if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.copydAllConversionsFolders(files[i]);
            }
        }
    }

    private void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                this.copyFolder(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    @Override
    public void execute(String ... args) {
        this.conversionDir = new File(args[1]);
        this.copydAllConversionsFolders(this.conversionDir);
    }

    @Override
    public boolean validate(String ... args) {
        boolean isValid = true;
        if (args.length != 3) {
            this.errorMessage = this.errorMessage + "\nWrong arguments number";
            isValid = false;
            this.RC = -1;
        } else {
            this.locationToSave = new File(args[0]);
            File conversionDir = new File(args[1]);
            this.folderToCopy = args[2];
            if (!conversionDir.isDirectory()) {
                isValid = false;
                this.errorMessage = this.errorMessage + "\nDirectory: " + conversionDir.getAbsolutePath() + " does not exist.";
                this.RC = -1;
            }
        }
        return isValid;
    }

    @Override
    public String getUsage() {
        return "USAGE : CopyAllConversionResultsFolders <SAVE_LOCATION> <CONVERSION_TOOL_LOCATION> <FOLDER_NAME_YOU_WHANT_TO_COPY>";
    }

    private String ListToString(List<String> strList) {
        StringBuilder toRet = new StringBuilder();
        if (strList != null && !strList.isEmpty()) {
            for (String str : strList) {
                toRet.append(str).append('\n');
            }
        } else {
            toRet.append("The results of the conversion tool had been successfully copyed to there destination.\n" + this.locationToSave.getAbsolutePath()).append('\n');
        }
        return toRet.toString();
    }

    @Override
    public String getOutput() {
        return this.ListToString(this.StdOut);
    }

    @Override
    public int getRC() {
        return this.RC;
    }

    @Override
    public String getValidationErrors() {
        return this.errorMessage;
    }
}

