/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.CD_DataAnalysis;

import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class cdprocess {
    public String file;
    public String cust;
    final Pattern continuationPatt = Pattern.compile(".*[-]\\s*$");
    final Pattern emptyLinePatt = Pattern.compile("\\s*$");
    final Pattern commentSingleLinPatt = Pattern.compile("^\\*.*$");
    final Pattern commentBlockStartPatt = Pattern.compile("^/\\*.*$");
    final Pattern commentBlockEndPatt = Pattern.compile(".*\\*\\/\\s*$");
    final Pattern retainYesPatt = Pattern.compile(".*retain=yes.*", 2);
    final Pattern lablePatt = Pattern.compile("^\\&?\\w.*$");
    final Pattern statmentLabledPatt = Pattern.compile("^(?<lable>\\&?\\w+)\\s*(?<cmd>\\w*)\\s*(?<param>.*)$");
    final Pattern statmentNoLabledPatt = Pattern.compile("^\\s*(?<cmd>\\&?\\w+)\\s*(?<param>.*)$");

    public boolean isContinuationLine(String line) {
        Matcher m = this.continuationPatt.matcher(line);
        boolean ret = m.matches();
        return ret;
    }

    public boolean isEmptyLine(String line) {
        Matcher m = this.emptyLinePatt.matcher(line);
        boolean ret = m.matches();
        return ret;
    }

    public boolean isCommentSingleLine(String line) {
        Matcher m = this.commentSingleLinPatt.matcher(line);
        boolean ret = m.matches();
        return ret;
    }

    public boolean isCommentBlockStartLine(String line) {
        Matcher m = this.commentBlockStartPatt.matcher(line);
        boolean ret = m.matches();
        return ret;
    }

    public boolean isCommentBlockEndLine(String line) {
        Matcher m = this.commentBlockEndPatt.matcher(line);
        boolean ret = m.matches();
        return ret;
    }

    public boolean isRetainYesdLine(String line) {
        Matcher m = this.retainYesPatt.matcher(line);
        boolean ret = m.matches();
        return ret;
    }

    public void parseStatmetLine(String line, Properties prop) {
        prop.setProperty("lable", "");
        prop.setProperty("cmd", "");
        prop.setProperty("param", "");
        Matcher m = this.lablePatt.matcher(line);
        if (m.matches()) {
            m = this.statmentLabledPatt.matcher(line);
            if (m.matches()) {
                prop.setProperty("lable", m.group("lable"));
            }
        } else {
            m = this.statmentNoLabledPatt.matcher(line);
        }
        if (m.matches()) {
            prop.setProperty("cmd", m.group("cmd"));
            prop.setProperty("param", m.group("param"));
        }
    }

    public ArrayList<Properties> analysis(String data) {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        Properties res = new Properties();
        String[] lines = data.split("\\r?\\n");
        int nStatmentLines = 0;
        int nEmptyLines = 0;
        int ncommentLines = 0;
        boolean isContinuation = false;
        boolean isCommentBlock = false;
        boolean isRetain = false;
        String process = "";
        StringBuffer commentText = new StringBuffer("");
        StringBuffer paramText = new StringBuffer("");
        for (String line : lines) {
            if (!isCommentBlock && this.isCommentBlockStartLine(line)) {
                isCommentBlock = true;
            }
            if (isCommentBlock) {
                ++ncommentLines;
                commentText.append(line);
                if (!this.isCommentBlockEndLine(line)) continue;
                isCommentBlock = false;
                continue;
            }
            if (this.isCommentSingleLine(line)) {
                ++ncommentLines;
                commentText.append(line);
                continue;
            }
            if (this.isEmptyLine(line)) {
                ++nEmptyLines;
                continue;
            }
            if (++nStatmentLines == 1) {
                this.parseStatmetLine(line, res);
                paramText.append(res.getProperty("param"));
                if (res.getProperty("cmd").equalsIgnoreCase("process")) {
                    process = res.getProperty("lable");
                }
            }
            if (isContinuation) {
                paramText.append(line);
            }
            if (isContinuation = this.isContinuationLine(line)) continue;
            if (this.isRetainYesdLine(line)) {
                isRetain = true;
            }
            res.setProperty("param", paramText.toString());
            res.setProperty("nStatmentLines", Integer.toString(nStatmentLines));
            res.setProperty("nEmptyLines", Integer.toString(nEmptyLines));
            res.setProperty("nCommentLines", Integer.toString(ncommentLines));
            res.setProperty("retain", String.valueOf(isRetain));
            if (process.isEmpty()) {
                res.setProperty("process", "_NOT_CDC_PROCESS");
                res.setProperty("cmd", line);
                ret.add(res);
                return ret;
            }
            res.setProperty("process", process);
            ret.add(res);
            res = new Properties();
            nStatmentLines = 0;
            nEmptyLines = 0;
            ncommentLines = 0;
            commentText = new StringBuffer("");
            paramText = new StringBuffer("");
            isContinuation = false;
        }
        return ret;
    }
}

