/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import SapExtractor.ConvSapExt;
import SapExtractor.FilterInfo;
import SapExtractor.LoginInfo;
import SapExtractor.SapExtException;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseButtonGroup;
import com.bmc.ctmconvert.base.BaseCheckBox;
import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseDateRange;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BasePasswordField;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.table.BaseExtendedTable;
import com.bmc.ctmconvert.base.table.BaseFilterableTable;
import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.base.table.BaseTableToolbar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.services.settings.Feature;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class DataImportSAP
extends DataImportVendor
implements ActionListener {
    private BaseSection section;
    protected ImportPanels importPanels = ImportPanels.DEFAULT;
    private BaseRadioButton automaticCollection;
    private BaseRadioButton manualCollection;
    private BaseTextField hostName;
    private BaseField hostNameField;
    private BaseTextField systemNumber;
    private BaseField systemNumberField;
    private BaseTextField userName;
    private BaseField userNameField;
    private BaseTextField clientNumber;
    private BaseField clientNumberField;
    private BasePasswordField password;
    private BaseField passwordField;
    protected BaseContentPanel automaticPanel;
    protected BaseContentPanel manualPanel;
    protected boolean eligibleForNext = true;
    private DefaultTableModel model;
    private ConvSapExt sapExt;
    private LoginInfo loginInfo;
    private FilterInfo filterInfo;
    private BaseTextField filterJobName;
    private BaseTextField filterJobCount;
    private BaseTextField filterUserName;
    private BaseDateRange dateRange;
    private BaseComboBox filterEventList;
    private BaseCheckBox filterStatusScheduled;
    private BaseCheckBox filterStatusActive;
    private BaseCheckBox filterStatusReleased;
    private BaseCheckBox filterStatusFinished;
    private JTextArea finshedStatusWarning;
    private BaseCheckBox filterStatusReady;
    private BaseCheckBox filterStatusCanceled;
    private BaseSection filterFieldsSection;
    private BaseRadioButton filterEvent;
    private BaseRadioButton filterFromToDate;
    private BaseField filterEventListField;
    private static boolean rc;

    public DataImportSAP() {
        ArrayList<BaseButton> componentList = new ArrayList<BaseButton>();
        final BaseButton button = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.TEST_CONNECTION, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataImportSAP.this.testConnection(true);
            }
        });
        button.setEnabled(false);
        componentList.add(button);
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_TITLE_SAP")), new BaseFooterPanel("", componentList));
        this.section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA")){

            public boolean isValid() {
                return DataImportSAP.this.manualCollection.isSelected() || DataImportSAP.this.hostNameField.isValid() && DataImportSAP.this.systemNumberField.isValid() && DataImportSAP.this.userNameField.isValid() && DataImportSAP.this.clientNumberField.isValid() && DataImportSAP.this.passwordField.isValid();
            }
        };
        this.section.addValidityListener(new ValidityListener(){

            public void validityActionPerformed(ConversionEvent e) {
                button.setEnabled(e.getValue() && DataImportSAP.this.automaticCollection.isSelected());
            }
        });
        BaseButtonGroup dataCollectionGroup = new BaseButtonGroup();
        SettingsTable settings = SettingsTable.instance();
        this.automaticCollection = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_AUTOMATIC"));
        this.automaticCollection.addActionListener((ActionListener)this);
        dataCollectionGroup.add(this.automaticCollection);
        String strAutomaticImport = String.format(TextManager.instance().get("SAP_DATA_IMPORT_AUTOMATIC_DESCRIPTION"), "\n", "\n", "\n");
        this.section.addField(new BaseField((BaseComponent)this.automaticCollection, null, strAutomaticImport));
        this.hostName = new BaseTextField(settings.getProperty(SettingsStringKeys.SAP_LOGIN_HOSTNAME), new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.hostNameField = new BaseField((BaseComponent)this.hostName, TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_HOSTNAME"), true, 17, TextManager.instance().get("SAP_HOST_NAME_DESCRIPTION"));
        this.hostNameField.setTooltip(TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_HOSTNAME"));
        this.section.addField(this.hostNameField);
        this.systemNumber = new BaseTextField(settings.getProperty(SettingsStringKeys.SAP_LOGIN_SYSTEM_NUMBER), new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.systemNumberField = new BaseField((BaseComponent)this.systemNumber, TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_SYSTEM_NUMBER"), true, 17, TextManager.instance().get("SAP_SYSTEM_NUMBER_DESCRIPTION"));
        this.section.addField(this.systemNumberField);
        this.clientNumber = new BaseTextField(settings.getProperty(SettingsStringKeys.SAP_LOGIN_CLIENT_NUMBER), new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.clientNumberField = new BaseField((BaseComponent)this.clientNumber, TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_CLIENT_NUMBER"), true, 17, TextManager.instance().get("SAP_CLIENT_NUMBER_DESCRIPTION"));
        this.section.addField(this.clientNumberField);
        this.userName = new BaseTextField(settings.getProperty(SettingsStringKeys.SAP_LOGIN_USERNAME), new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.userNameField = new BaseField((BaseComponent)this.userName, TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_USERNAME"), true, 17, TextManager.instance().get("SAP_USER_NAME_DESCRIPTION"));
        this.userNameField.setTooltip(TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_USERNAME"));
        this.section.addField(this.userNameField);
        this.password = new BasePasswordField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.passwordField = new BaseField((BaseComponent)this.password, TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_PASSWORD"), true, 17, TextManager.instance().get("SAP_PASSWORD_DESCRIPTION"));
        this.passwordField.setTooltip("Password");
        this.section.addField(this.passwordField);
        this.manualCollection = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_MANUAL"));
        this.manualCollection.addActionListener((ActionListener)this);
        dataCollectionGroup.add(this.manualCollection);
        String strManualImport = String.format(TextManager.instance().get("SAP_DATA_IMPORT_MANUAL_DESCRIPTION"), "\n", "\n", "\n");
        this.section.addField(new BaseField((BaseComponent)this.manualCollection, null, strManualImport));
        String importType = settings.getProperty(SettingsStringKeys.SAP_DATA_IMPORT_TYPE, "AUTOMATIC");
        if (importType.equals("MANUAL")) {
            this.manualCollection.doClick();
        } else {
            this.automaticCollection.doClick();
        }
        this.importPanel.addSection(this.section);
        this.importPanel.buildContentPanel();
    }

    public boolean eligibleForNext() {
        return this.eligibleForNext;
    }

    public Component getDefaultFocusedComponent() {
        switch (this.importPanels.ordinal()) {
            case 0: {
                return this.automaticCollection.isSelected() ? this.automaticCollection.getComponent() : this.manualCollection.getComponent();
            }
            case 1: {
                return this.filterJobName.getComponent();
            }
        }
        return null;
    }

    private boolean testConnection(boolean alert) {
        boolean success = true;
        Object message = "";
        try {
            Class.forName("com.sap.conn.jco.JCoContext");
        }
        catch (ClassNotFoundException e) {
            message = TextManager.instance().get("DATA_IMPORT_SAPJCO_NOT_EXIST") + "\n" + TextManager.instance().get("DATA_IMPORT_REFERENCE_TO_HELP");
            success = false;
        }
        if (success) {
            this.loginInfo = new LoginInfo();
            this.loginInfo.set_hostName(this.hostName.getText());
            this.loginInfo.set_systemNumber(this.systemNumber.getText());
            this.loginInfo.set_userName(this.userName.getText());
            this.loginInfo.set_clientNumber(this.clientNumber.getText());
            this.loginInfo.set_password(this.password.getText());
            try {
                boolean trace = SettingsTable.instance().getProperty((Feature)SettingsBooleanKeys.SAP_AUTOMATIC_IMPORT_TRACE);
                this.sapExt = new ConvSapExt(trace, Globs.LOGS_DIR);
                this.sapExt.testConnection(this.loginInfo);
                SettingsTable settings = SettingsTable.instance();
                settings.setProperty(SettingsStringKeys.SAP_LOGIN_HOSTNAME, this.loginInfo.get_hostName());
                settings.setProperty(SettingsStringKeys.SAP_LOGIN_SYSTEM_NUMBER, this.loginInfo.get_systemNumber());
                settings.setProperty(SettingsStringKeys.SAP_LOGIN_CLIENT_NUMBER, this.loginInfo.get_clientNumber());
                settings.setProperty(SettingsStringKeys.SAP_LOGIN_USERNAME, this.loginInfo.get_userName());
                settings.setProperty(SettingsStringKeys.SAP_DATA_IMPORT_TYPE, "AUTOMATIC");
            }
            catch (SapExtException e) {
                message = "Error: " + e.getLocalizedMessage();
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
                success = false;
            }
            catch (Error e) {
                message = "Error: " + e.getLocalizedMessage();
                ExceptionHandler.writeToExceptionFile((String)e.getLocalizedMessage());
                success = false;
            }
        }
        if (alert) {
            if (success) {
                BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_TITLE"), (String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_SUCCESS"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.SUCCESS_MESSAGE);
            } else {
                BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_TITLE"), (String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_FAILURE"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)message);
            }
        } else {
            ProcessAlertsManager.instance().init();
            ProcessAlertsManager.instance().addMessage((String)message);
        }
        return success;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setAutomaticEnabled(this.automaticCollection.isSelected());
        this.section.fireValidityEvent(this.section.isValid());
    }

    private void setAutomaticEnabled(boolean b) {
        this.hostNameField.setEnabled(b);
        this.systemNumberField.setEnabled(b);
        this.userNameField.setEnabled(b);
        this.clientNumberField.setEnabled(b);
        this.passwordField.setEnabled(b);
    }

    public DataImportVendor.ImportPosition getImportPosition() {
        switch (this.importPanels.ordinal()) {
            case 0: 
            case 3: {
                return DataImportVendor.ImportPosition.START;
            }
        }
        return DataImportVendor.ImportPosition.END;
    }

    public BaseContentPanel getNextPanel() {
        BaseContentPanel toRet = null;
        switch (this.importPanels.ordinal()) {
            case 0: {
                if (this.automaticCollection.isSelected()) {
                    if (this.testConnection(false)) {
                        this.eligibleForNext = true;
                        this.importPanels = ImportPanels.AUTOMATIC_DATA_IMPORT;
                        toRet = this.getAutomaticImportPanel();
                        break;
                    }
                    BaseMessageDialog.showMessageDialog((String)"SAP Connection", (String)"Connection failed", (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)ProcessAlertsManager.instance().getMessages());
                    this.eligibleForNext = false;
                    break;
                }
                this.importPanels = ImportPanels.MANUAL_DATA_IMPORT;
                toRet = this.getManualImportPanel();
                break;
            }
            case 1: 
            case 2: {
                toRet = null;
                break;
            }
            default: {
                this.importPanels = ImportPanels.DATA_IMPORT;
                toRet = this.importPanel;
            }
        }
        return toRet;
    }

    public BaseContentPanel getPrevPanel() {
        BaseContentPanel toRet = null;
        switch (this.importPanels.ordinal()) {
            case 0: {
                this.eligibleForNext = true;
                toRet = null;
                break;
            }
            case 1: 
            case 2: {
                this.importPanels = ImportPanels.DATA_IMPORT;
                toRet = this.importPanel;
                break;
            }
        }
        return toRet;
    }

    private BaseContentPanel getAutomaticImportPanel() {
        if (this.automaticPanel == null) {
            this.automaticPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_AUTOMATIC"), TextManager.instance().get("DATA_IMPORT_FILTER_INSTRUCTION")));
            this.filterFieldsSection = new BaseSection(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_GENERAL_SECTION_TITLE")){

                public boolean isValid() {
                    return DataImportSAP.this.filterJobName.isValid() && DataImportSAP.this.filterUserName.isValid();
                }
            };
            this.filterJobName = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY_SAP));
            this.filterFieldsSection.addField(new BaseField((BaseComponent)this.filterJobName, TextManager.instance().get("DATA_IMPORT_SAP_FILTER_JOBNAME"), true));
            this.filterUserName = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY_SAP));
            BaseField filterUserNameField = new BaseField((BaseComponent)this.filterUserName, TextManager.instance().get("DATA_IMPORT_SAP_FILTER_USERNAME"), true);
            filterUserNameField.setTooltip(TextManager.instance().get("DATA_IMPORT_SAP_LOGIN_FIELD_USERNAME"));
            this.filterFieldsSection.addField(filterUserNameField);
            this.filterJobCount = new BaseTextField();
            this.filterFieldsSection.addField(new BaseField((BaseComponent)this.filterJobCount, TextManager.instance().get("DATA_IMPORT_SAP_FILTER_JOB_COUNT")));
            BaseButtonGroup buttonsGroup = new BaseButtonGroup();
            this.filterFromToDate = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_FROM_TO_DATE"));
            this.filterFromToDate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataImportSAP.this.filterEventListField.setEnabled(false);
                    DataImportSAP.this.dateRange.setEnabled(true);
                }
            });
            buttonsGroup.add(this.filterFromToDate);
            BaseField filterFromToDateField = new BaseField((BaseComponent)this.filterFromToDate);
            filterFromToDateField.fillFieldSize(true);
            this.filterFieldsSection.addField(filterFromToDateField);
            this.dateRange = new BaseDateRange();
            BaseField dateRangeField = new BaseField((BaseComponent)this.dateRange, 17);
            dateRangeField.fillFieldSize(true);
            this.filterFieldsSection.addField(dateRangeField);
            this.filterEvent = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_AFTER_EVENT"));
            this.filterEvent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataImportSAP.this.filterEventListField.setEnabled(true);
                    DataImportSAP.this.dateRange.setEnabled(false);
                }
            });
            buttonsGroup.add(this.filterEvent);
            BaseField filterEventField = new BaseField((BaseComponent)this.filterEvent);
            filterEventField.fillFieldSize(true);
            this.filterFieldsSection.addField(filterEventField);
            this.filterEventList = new BaseComboBox(new Object[0], TextManager.instance().get("DATA_IMPORT_SAP_FILTER_AFTER_EVENT_LIST_DEFAULT"));
            this.filterEventList.disableValidityLook(true);
            this.filterEventList.setEditable(true);
            this.filterEventListField = new BaseField((BaseComponent)this.filterEventList, 17);
            this.filterEventListField.fillFieldSize(true);
            this.filterFieldsSection.addField(this.filterEventListField);
            this.automaticPanel.addSection(this.filterFieldsSection);
            BaseSection statusSection = new BaseSection(this, TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUSES_SECTION_TITLE")){

                public boolean isValid() {
                    return true;
                }
            };
            this.filterStatusScheduled = new BaseCheckBox(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUS_SCHEDULED"));
            statusSection.addField(new BaseField((BaseComponent)this.filterStatusScheduled));
            this.filterStatusActive = new BaseCheckBox(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUS_ACTIVE"));
            statusSection.addField(new BaseField((BaseComponent)this.filterStatusActive));
            this.filterStatusReleased = new BaseCheckBox(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUS_RELEASED"));
            statusSection.addField(new BaseField((BaseComponent)this.filterStatusReleased));
            this.filterStatusReady = new BaseCheckBox(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUS_READY"));
            statusSection.addField(new BaseField((BaseComponent)this.filterStatusReady));
            this.filterStatusCanceled = new BaseCheckBox(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUS_CANCELED"));
            statusSection.addField(new BaseField((BaseComponent)this.filterStatusCanceled));
            this.filterStatusFinished = new BaseCheckBox(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUS_FINISHED"));
            statusSection.addField(new BaseField((BaseComponent)this.filterStatusFinished));
            this.finshedStatusWarning = new JTextArea(String.format(TextManager.instance().get("DATA_IMPORT_SAP_FILTER_STATUS_FINISHED_WARNING"), "\n"));
            this.finshedStatusWarning.setEditable(false);
            this.finshedStatusWarning.setFont(FlowGlobals.FONT_STYLE_REGULAR);
            this.finshedStatusWarning.setForeground(FlowGlobals.ConversionBlue);
            this.finshedStatusWarning.setVisible(false);
            this.finshedStatusWarning.setBackground(null);
            this.filterStatusFinished.addValidityListener(new ValidityListener(){

                public void validityActionPerformed(ConversionEvent e) {
                    DataImportSAP.this.finshedStatusWarning.setVisible(e.getValue());
                }
            });
            statusSection.addField(new BaseField((BaseComponent)new BaseComponentWrapper((Component)this.finshedStatusWarning)));
            this.automaticPanel.addSection(statusSection);
            this.automaticPanel.buildContentPanel();
        }
        ArrayList events = new ArrayList();
        try {
            events = this.sapExt.getEventNames(this.loginInfo);
            this.filterEventList.updateData(events.toArray());
        }
        catch (SapExtException e) {
            ConversionLogger.getLogger().info(e.getLocalizedMessage());
        }
        this.filterFieldsSection.setValid(this.filterFieldsSection.isValid());
        this.filterFromToDate.doClick();
        return this.automaticPanel;
    }

    private BaseContentPanel getManualImportPanel() {
        if (this.manualPanel == null) {
            JPanel dataPanel = new JPanel();
            dataPanel.setLayout(new BorderLayout());
            dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.model = new BaseTableModel((Object[][])new String[0][], new String[]{"File name", "File Path"});
            this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    DataImportSAP.this.manualPanel.setValid(DataImportSAP.this.model.getRowCount() > 0);
                }
            });
            final BaseFilterableTable baseFilterableTable = new BaseFilterableTable();
            baseFilterableTable.setModel(this.model);
            baseFilterableTable.setColumnWidth(0, 200);
            BaseTableToolbar filtersToolbar = new BaseTableToolbar();
            BaseButton add = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.ADD);
            add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseTextField tmp = new BaseTextField();
                    tmp.getComponent().setName("SAP Data");
                    GlobalFunctions.browseClick((JTextField)((JTextField)tmp.getComponent()), (String[])new String[]{"XML"}, (boolean)true);
                    String[] files = tmp.getText().split(";");
                    for (int index = 0; index < files.length; ++index) {
                        DataImportSAP.this.model.addRow(new String[]{files[index].substring(files[index].lastIndexOf(Globs.DIRSEP) + 1), files[index]});
                    }
                }
            });
            add.setEnabled(true);
            filtersToolbar.add((Component)add);
            filtersToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            final BaseButton delete = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.DELETE);
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    baseFilterableTable.removeRow(baseFilterableTable.getSelectedRowIndex());
                }
            });
            filtersToolbar.add((Component)delete);
            filtersToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            baseFilterableTable.addSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    delete.setEnabled(baseFilterableTable.getSelectedRowIndex() > -1);
                }
            });
            BaseExtendedTable filtersList = new BaseExtendedTable(baseFilterableTable, filtersToolbar, null);
            this.manualPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_MANUAL")));
            dataPanel.add(filtersList.getComponent());
            this.manualPanel.setContentPanel((Component)dataPanel);
        }
        return this.manualPanel;
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        switch (this.importPanels.ordinal()) {
            case 1: {
                this.filterInfo = new FilterInfo();
                this.filterInfo.set_jobName(this.filterJobName.getText());
                this.filterInfo.set_jobCount(this.filterJobCount.getText());
                this.filterInfo.set_user(this.filterUserName.getText());
                if (this.filterFromToDate.isSelected()) {
                    Date from = this.dateRange.getFromDate();
                    Date to = this.dateRange.getToDate();
                    if (from != null) {
                        this.filterInfo.set_fromDate(new SimpleDateFormat("yyyyMMdd").format(from));
                    }
                    if (to != null) {
                        this.filterInfo.set_toDate(new SimpleDateFormat("yyyyMMdd").format(to));
                    }
                } else {
                    this.filterInfo.set_afterEvent(this.filterEventList.getSelectedItem().toString());
                }
                this.filterInfo.set_statusScheduled(this.filterStatusScheduled.isSelected() ? "X" : "");
                this.filterInfo.set_statusActive(this.filterStatusActive.isSelected() ? "X" : "");
                this.filterInfo.set_statusReleased(this.filterStatusReleased.isSelected() ? "X" : "");
                this.filterInfo.set_statusCanceled(this.filterStatusCanceled.isSelected() ? "X" : "");
                this.filterInfo.set_statusReady(this.filterStatusReady.isSelected() ? "X" : "");
                this.filterInfo.set_statusFinished(this.filterStatusFinished.isSelected() ? "X" : "");
                String dataFile = String.format("%sData-%d.xml", Params.instance().getVendorName(), 1);
                this.filterInfo.set_outputFile(String.format("%s%s", destinationFolderPath, dataFile));
                return DataImportSAP.performDataImport(this.loginInfo, this.filterInfo, progressBar);
            }
            case 2: {
                ArrayList<String> files = new ArrayList<String>();
                for (int index = 0; index < this.model.getRowCount(); ++index) {
                    files.add(this.model.getValueAt(index, 1).toString());
                }
                return DataImportSAP.performDataImport(destinationFolderPath, files, progressBar);
            }
        }
        return FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    public static FlowGlobals.COMPLETION_MODE performDataImport(final LoginInfo loginInfo, final FilterInfo filterInfo, BaseProgressBar progressBar) {
        rc = true;
        boolean trace = SettingsTable.instance().getProperty((Feature)SettingsBooleanKeys.SAP_AUTOMATIC_IMPORT_TRACE);
        final ConvSapExt sapExt = new ConvSapExt(trace, Globs.LOGS_DIR);
        Thread getJobsData = new Thread(){

            @Override
            public void run() {
                try {
                    sapExt.getData(loginInfo, filterInfo);
                }
                catch (SapExtException e) {
                    DataImportSAP.handleSapExtException(e);
                }
            }
        };
        getJobsData.start();
        if (progressBar != null) {
            progressBar.setLabel(TextManager.instance().get("DATA_IMPORT_SAP_PROGRESS_MESSAGE_CONNECTING"));
        }
        while (rc) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            if (sapExt.getTotalNumberOfJobs() <= 0) continue;
        }
        if (progressBar != null) {
            progressBar.setProgressMax(sapExt.getTotalNumberOfJobs());
        }
        while (rc) {
            if (progressBar != null) {
                if (progressBar.isCancelled()) {
                    getJobsData.stop();
                    return FlowGlobals.COMPLETION_MODE.ABORTED;
                }
                int extractedJobsCount = sapExt.getNumberOfJobsExtractedSoFar();
                progressBar.setLabel(String.format(TextManager.instance().get("DATA_IMPORT_SAP_PROGRESS_MESSAGE_EXTRACTING_FORMAT"), extractedJobsCount, sapExt.getTotalNumberOfJobs()));
                progressBar.setProgressValue(extractedJobsCount);
            }
            if (sapExt.getNumberOfJobsExtractedSoFar() == sapExt.getTotalNumberOfJobs()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        if (rc) {
            try {
                getJobsData.join();
            }
            catch (InterruptedException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return rc ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    private static void handleSapExtException(SapExtException e) {
        ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
        ProcessAlertsManager.instance().addMessage(e.getMessage());
        rc = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, ArrayList<String> filesPath, BaseProgressBar progressBar) {
        FlowGlobals.COMPLETION_MODE toRet = FlowGlobals.COMPLETION_MODE.FAILURE;
        if (progressBar != null) {
            progressBar.setProgressMax(filesPath.size());
        }
        for (int index = 0; index < filesPath.size(); ++index) {
            File sourceFile = new File(filesPath.get(index));
            if (progressBar != null) {
                progressBar.setLabel(String.format(TextManager.instance().get("DATA_IMPORT_SAP_PROGRESS_MESSAGE_MANUAL_FORMAT"), sourceFile.getName()));
                progressBar.setProgressValue(index);
                if (progressBar.isCancelled()) {
                    toRet = FlowGlobals.COMPLETION_MODE.ABORTED;
                    break;
                }
            }
            String dataFile = String.format("%sData-%d.xml", Params.instance().getVendorName(), index);
            if (sourceFile.getName().isEmpty()) continue;
            File destinationFile = new File(String.format("%s%s", destinationFolderPath, dataFile));
            try {
                FileFunctions.copyFile((File)sourceFile, (File)destinationFile);
                toRet = FlowGlobals.COMPLETION_MODE.SUCCESS;
                continue;
            }
            catch (IOException e) {
                ProcessAlertsManager.instance().addMessage(String.format(TextManager.instance().get("DATA_IMPORT_COPY_FILE_ERROR_FORMAT"), sourceFile.toString(), destinationFile.toString()));
                continue;
            }
            finally {
                sourceFile = null;
                destinationFile = null;
            }
        }
        return toRet;
    }

    public String getHelpTitle() {
        switch (this.importPanels.ordinal()) {
            case 0: {
                return "LOAD_DATA_SAP_MANUAL_OR_AUTOMATIC";
            }
            case 1: {
                return "LOAD_DATA_SAP_AUTOMATIC";
            }
            case 2: {
                return "LOAD_DATA_SAP_MANUAL";
            }
        }
        return "";
    }

    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.automaticCollection.isSelected()) {
            stringBuilder.append(this.hostName.getComponent().getName() + "=" + this.hostName.getText() + "\n");
            stringBuilder.append(this.systemNumber.getComponent().getName() + "=" + this.systemNumber.getText() + "\n");
            stringBuilder.append(this.userName.getComponent().getName() + "=" + this.userName.getText() + "\n");
            stringBuilder.append(this.clientNumber.getComponent().getName() + "=" + this.clientNumber.getText() + "\n");
            stringBuilder.append(this.filterJobName.getComponent().getName() + "=" + this.filterJobName.getText() + "\n");
            stringBuilder.append(this.filterJobCount.getComponent().getName() + "=" + this.filterJobCount.getText() + "\n");
            stringBuilder.append(this.filterUserName.getComponent().getName() + "=" + this.filterUserName.getText() + "\n");
            if (this.filterFromToDate.isSelected()) {
                Date from = this.dateRange.getFromDate();
                Date to = this.dateRange.getToDate();
                if (from != null) {
                    stringBuilder.append(this.filterFromToDate.getComponent().getName() + " From=" + new SimpleDateFormat("yyyyMMdd").format(from) + "\n");
                }
                if (to != null) {
                    stringBuilder.append(this.filterFromToDate.getComponent().getName() + " To=" + new SimpleDateFormat("yyyyMMdd").format(to) + "\n");
                }
            } else {
                stringBuilder.append(this.filterEventList.getComponent().getName() + "=" + this.filterEventList.getSelectedItem().toString() + "\n");
            }
            stringBuilder.append(this.filterStatusScheduled.getComponent().getName() + "=" + (this.filterStatusScheduled.isSelected() ? "X" : "") + "\n");
            stringBuilder.append(this.filterStatusActive.getComponent().getName() + "=" + (this.filterStatusActive.isSelected() ? "X" : "") + "\n");
            stringBuilder.append(this.filterStatusReleased.getComponent().getName() + "=" + (this.filterStatusReleased.isSelected() ? "X" : "") + "\n");
            stringBuilder.append(this.filterStatusCanceled.getComponent().getName() + "=" + (this.filterStatusCanceled.isSelected() ? "X" : "") + "\n");
            stringBuilder.append(this.filterStatusReady.getComponent().getName() + "=" + (this.filterStatusReady.isSelected() ? "X" : "") + "\n");
            stringBuilder.append(this.filterStatusFinished.getComponent().getName() + "=" + (this.filterStatusFinished.isSelected() ? "X" : "") + "\n");
        } else {
            stringBuilder.append(this.model.getDataVector().toString() + "\n");
        }
        return stringBuilder.toString();
    }

    public static enum ImportPanels {
        DATA_IMPORT,
        AUTOMATIC_DATA_IMPORT,
        MANUAL_DATA_IMPORT,
        DEFAULT;

    }
}

