from folder import folder
from folder_fetcher import folder_fetcher


class folder_fetcher_from_test_file(folder_fetcher):
    #
    # This class implements the folder_fetcher interface from a sequantial test file (debug purposes).
    # Note that the "exclude file" is ignored.
    #

    def __init__(self, filename):
        self._input_file_ = open(filename, 'r')
        self._neof_ = True
        self._line_ = ''
        self._folder_ = None

    def get_folder(self):

        if self._neof_ == False:
            return None

        while self._neof_ and self._line_[0:2] != 'F=':
            self._read_line_()

        if self._line_[0:2] == 'F=':
            del self._folder_
            self._folder_ = folder(self._line_[2:len(self._line_) - 1])

        self._read_line_()
        while self._neof_ and self._line_[0:2] != 'F=':
            if self._line_[0:1] == '+':
                self._folder_.add_resource(self._line_[1:len(self._line_) - 1])
            if self._line_[0:1] == '.':
                for _ in range(0, int(self._line_[1:len(self._line_) - 1])):
                    self._folder_.add1_to_jobs_counter()
            self._read_line_()

        return self._folder_

    def _read_line_(self):
        self._line_ = self._input_file_.readline()
        if not self._line_:
            self._neof_ = False
            self._input_file_.close()
