# Workflow Splitter

A Python utility for splitting large Control-M workflows into smaller, independent sub-workflows by analyzing resource dependencies and grouping folders that share no common resources.

## Overview

The Workflow Splitter (`workflow_splitter.py`) helps break down monolithic Control-M server workflows into multiple smaller workflows that can run independently.

## Features

- **Resource Dependency Analysis**: Analyzes jobs, variables, events, and resources to identify dependencies
- **Intelligent Grouping**: Groups folders that share resources while keeping independent folders separate
- **Configurable Processing**: Control which elements to process (events, variables, resources, etc.)
- **JSON Output**: Generates sub-JSON files for each independent workflow group
- **Excel Reporting**: Creates detailed reports of the splitting results
- **Exclude Lists**: Support for excluding specific resources from analysis

## Prerequisites

- Python 3.x
- Required Python modules (see codebase for details)

## Usage

### Basic Usage
```cmd
python workflow_splitter.py
```

### With Custom Parameters File
```cmd
python workflow_splitter.py path\to\custom_parameters.txt
```

If no parameters file is specified, the script defaults to `parameters/invocation_parms.txt`.

## Configuration

The script uses a configuration file with the following parameters:

| Parameter                | Description                                 | Example                       |
|--------------------------|---------------------------------------------|-------------------------------|
| input_file_name          | Path to the input JSON workflow file         | c:\data\jobDefinitions.json   |
| exclude_file_name        | Path to file containing resources to exclude | c:\data\exclude_resources.txt |
| output_folder            | Directory for output files                   | ./output                      |
| manage_events            | Process event dependencies                   | Yes/No                        |
| manage_vars              | Process variable dependencies                | Yes/No                        |
| manage_res               | Process resource dependencies                | Yes/No                        |
| manage_qres              | Process quantitative resource dependencies   | Yes/No                        |
| generate_sub_jsons       | Generate sub-JSON files                      | Yes/No                        |
| max_jobs_in_json         | Maximum jobs per JSON file (0 = no limit)    | 7500                          |
| write_output_to_terminal | Display detailed output to console           | Yes/No                        |

### Sample Configuration File
```text
input_file_name = c:\data\jobDefinitions.json
exclude_file_name = c:\data\exclude_resources.txt
output_folder = ./output
manage_events = Yes
manage_vars = Yes
manage_res = Yes
manage_qres = Yes
generate_sub_jsons = Yes
max_jobs_in_json = 7500
write_output_to_terminal = No
```

## Output

The script generates:

1. **Sub-JSON Files**: Individual workflow files for each independent group (when `generate_sub_jsons = Yes`)
2. **Excel Report**: Detailed analysis and grouping results
3. **Console Output**: Progress information and group statistics (when `write_output_to_terminal = Yes`)




