#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
import xlrd
from os.path import isfile, join
from os import listdir

def main(argv):
    input_file =  'in.xml'
    output_file = 'output.xml'
    script_file = 'script.bat'
    modified_script_file = 'modified_script.bat'
    names_file = 'short_names.xlsx'
    try:
        opts, args = getopt.getopt(argv,"hi:o:s:m:n:",["ifile=","ofile=","script=","modified=","names="])
    except getopt.GetoptError:
        print ('xml-set-pool-by-appl.py -i <inputfile> -o <outputfile> -s <scriptbat> -m <modifiedscript> -n <namesexcel>')
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print ('xml-set-pool-by-appl.py -i <inputfile> -o <outputfile> -s <scriptbat> -m <modifiedscript> -n <namesexcel>')
            sys.exit()
        elif opt in ("-i", "--ifile"):
            input_file = arg
        elif opt in ("-o", "--ofile"):
            output_file = arg
        elif opt in ("-s", "--script"):
            script_file = arg
        elif opt in ("-m", "--modified"):
            modified_script_file = arg
        elif opt in ("-n", "--names"):
            names_file = arg
    print ('Input file is: ' + input_file)
    print ('Output file is: ' + output_file)
    print ('Script file is: ' + script_file)
    print ('Modified Script file is: ' + modified_script_file)
    print ('Names file is: ' + names_file)
    
    short_name_dict = generate_short_name_dict(names_file)

    tree = ET.parse(input_file); print("Read the input file: " + input_file)
    root = tree.getroot()

    replace_pool_folders(root, short_name_dict); print("Changed all folders that use global pool.")
    replace_pool_jobs(root, short_name_dict); print("Changed all jobs that use global pool.")
    update_pool_in_script(script_file, short_name_dict, modified_script_file); print("Changed script that use global pool.")

    print("Writing updates to the XML file...")
    tree.write(output_file);print("Updates saved to the output XML file.")

def replace_pool_jobs(root, short_name_dict):
    for job in root.iter('JOB'):
        try: 
            memname = job.attrib['JOBNAME']
        except KeyError:
            continue
        try: 
            application = job.attrib['APPLICATION']
        except KeyError:
            continue
        acronym = extract_acronym(application, short_name_dict)
        system_pool = "%%\\\\SYSTEM_VARIABLE"
        variable_list = job.iter('VARIABLE')
        for variable in variable_list:
            var_name = variable.attrib['NAME']
            if (var_name.find(system_pool) >= 0):
                new_var_name = var_name.replace(system_pool,"%%\\\\" + acronym)
                variable.attrib['NAME'] = new_var_name
            var_value = variable.attrib['VALUE']
            if (var_value.find(system_pool) >= 0):
                new_var_value = var_value.replace(system_pool,"%%\\\\" + acronym)
                variable.attrib['VALUE'] = new_var_value
        try: 
            cmdline = job.attrib['CMDLINE']
            if (cmdline.find(system_pool) >= 0):
                new_cmdline = cmdline.replace(system_pool,"%%\\\\" + acronym)
                job.attrib['CMDLINE'] = new_cmdline
        except KeyError:
            continue

        domail_list = job.iter('DOMAIL')
        for domail in domail_list:
            message = domail.attrib['MESSAGE']
            if (message.find(system_pool) >= 0):
                new_message = message.replace(system_pool,"%%\\\\" + acronym)
                domail.attrib['MESSAGE'] = new_message

    return

def replace_pool_folders(root, short_name_dict):
    for folder in root.iter('SMART_FOLDER'):
        try: 
            memname = folder.attrib['FOLDER_NAME']
        except KeyError:
            continue
        try: 
            application = folder.attrib['APPLICATION']
        except KeyError:
            continue
        acronym = extract_acronym(application, short_name_dict)
        variable_list = folder.iter('VARIABLE')
        system_pool = "%%\\\\SYSTEM_VARIABLE"
        for variable in variable_list:
            var_name = variable.attrib['NAME']
            if (var_name.find(system_pool) >= 0):
                new_var_name = var_name.replace(system_pool,"%%\\\\" + acronym)
                variable.attrib['NAME'] = new_var_name
            var_value = variable.attrib['VALUE']
            if (var_value.find(system_pool) >= 0):
                new_var_value = var_value.replace(system_pool,"%%\\\\" + acronym)
                variable.attrib['VALUE'] = new_var_value
    return

def extract_acronym(application, short_name_dict):
    # sn = short_name_dict.get(application)
    # if sn ne None:
    if application in short_name_dict:
        acronym = short_name_dict[application]
    else:
        acronym = ""
        word_list = application.split("_")
        for word in word_list:
            acronym = acronym + word[:1]
        short_name_dict[application] = acronym
        print ('Application abbreviation was missing. {} was used instead of the full name {}'.format(acronym, application))
    return acronym

def generate_short_name_dict(names_file):
    short_name_dict = dict()
    wb = xlrd.open_workbook(names_file) 
    sheet = wb.sheet_by_index(0) 
    for row in range(sheet.nrows):
        full_name = sheet.cell_value(row, 0)
        short_name = sheet.cell_value(row, 1)
        short_name_dict[full_name] = short_name
    return short_name_dict


def update_pool_in_script(script_file, short_name_dict, modified_script_file):
    with open(script_file, 'r') as script_content_file:
        script_content = script_content_file.read()
        script_content_lines =script_content.split('\n')
        script_content_file.close()
        with open(modified_script_file, 'w') as script_modified_content_file:
            for script_content_line in script_content_lines:
                modified_line = script_content_line
                script_command_items = script_content_line.split(" ")
                if script_command_items[0] == 'ctmvar':
                    application = script_command_items[4][1:-1]
                    acronym = extract_acronym(application, short_name_dict)
                    modified_line = script_content_line.replace(application, acronym)
                script_modified_content_file.writelines(modified_line + '\n')
    script_modified_content_file.close()

    return

start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")