#!/usr/bin/python
#coding=utf8


import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re
import logging 
import logging.handlers


USAGE= "cleanup-at-job-level-only.py -m <inputfile> -d <inputfile> -o <outputdir> [-f <suffix>]  [-c <comparedir>] [-l | -u (default) | -s] -r <remove date> -g <loglevel>"
def main(argv):
    input_mf_file =  ''
    input_ds_file =  ''
    output_dir = 'out'
    compare_dir = ''
    global ok_suffix, condition_format, remove_date, conditions_names, sched_id_sep
    ok_suffix = '_OK'
    sched_id_sep = '!'
    condition_format = 'u'
    remove_date = "ODAT"
    log_level = 'warning'
    try:
        opts, args = getopt.getopt(argv,"hlsur:c:m:d:o:f:g:",["mffile=","dsfile=","odir=","loglevel="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt == "-l":
                condition_format = 'l'
        elif opt == "-u":
                condition_format = 'u'
        elif opt == "-s":
                condition_format = 's'
        elif opt in ("-g", "--loglevel"):
                log_level = arg.lower()
        elif opt == "-c":
            compare_dir = arg
        elif opt == "-f":
            ok_suffix = arg
        elif opt == "-r":
            remove_date = arg
        elif opt in ("-m", "--mffile"):
            input_mf_file = arg
        elif opt in ("-d", "--dsfile"):
            input_ds_file = arg
        elif opt in ("-o", "--odir"):
            output_dir= arg

    if output_dir.endswith('\\') or output_dir.endswith('/'):
        output_dir = output_dir[:-1]
        
    if not os.path.isdir(output_dir):
        print ('Output dir does not exist - it will be created')
        os.makedirs(output_dir)
                
    p = os.path.abspath(__file__)
    log_dir = os.path.dirname(p)        
    
    file_handler = logging.FileHandler(log_dir + "\\cleanup.log", mode='w')

    memory_handler = logging.handlers.MemoryHandler(
        capacity=500000,
        flushLevel=logging.ERROR,  # Flush on ERROR or higher
        target=file_handler
    )   

    formatter = logging.Formatter(
                    fmt='%(asctime)s %(levelname)s %(message)s', # log format date/time INFO message
                    datefmt='%Y-%m-%d %H:%M:%S') 
    file_handler.setFormatter(formatter)
    memory_handler.setFormatter(formatter)
    
    global logger 
    logger = logging.getLogger()  
    if log_level == 'debug':
        logger.setLevel(logging.DEBUG)
    elif log_level == 'info':
        logger.setLevel(logging.INFO)
    elif log_level == 'error':
        logger.setLevel(logging.ERROR)
    elif log_level == 'warning':
        logger.setLevel(logging.WARNING)
    else:
        print('Invalid log level:' , log_level, 'must be DEBUG/INFO/ERROR/WARNING' )
    logger.addHandler(memory_handler)
    
    logger.info(' script parameters: ' + str(args))
    logger.info(' script options   : ' + str(opts))
    logger.info('Input file from MF is: ' + input_mf_file)
    logger.info('Input file from DS is: ' + input_ds_file)
    logger.info('Output dir is: ' + output_dir)


    print ('Input file from MF is: ' + input_mf_file)
    print ('Input file from DS is: ' + input_ds_file)
    print ('Output dir is: ' + output_dir)
    if len(compare_dir) > 0:
        print ('Output dir is: ' + compare_dir)
        logger.info('Output dir is: ' + compare_dir)
    print ('Suffix in effect: ' + ok_suffix)
    print ('Condition format: ' + condition_format)
    logger.info('Suffix in effect: ' + ok_suffix)
    logger.info('Condition format: ' + condition_format)

    tree_mf = ET.parse(input_mf_file); print("Read the MF input file: " + input_mf_file)
    root_mf = tree_mf.getroot()
    tree_ds = ET.parse(input_ds_file); print("Read the DS input file: " + input_ds_file)
    root_ds = tree_ds.getroot()

    if len(compare_dir) > 0:
        tree_mf.write(compare_dir + "\\" + os.path.basename(input_mf_file));print("MF original saved for comparison.")
        tree_ds.write(compare_dir + "\\" + os.path.basename(input_ds_file));print("DS original saved for comparison.")


    process_all_folders(root_mf, root_ds)

    print("Writing updates to the XML file...")

    tree_mf.write(output_dir + "\\" + os.path.basename(input_mf_file));print("MF updates saved to the output XML file.")
    tree_ds.write(output_dir + "\\" + os.path.basename(input_ds_file));print("DS updates saved to the output XML file.")

def process_all_folders(root_mf, root_ds):
    req_condition_list = get_req_condition_list(root_mf, [])
    req_condition_list = get_req_condition_list(root_ds, req_condition_list)
    folder_mf_dict = build_folder_dict(root_mf); print("Got all MF folders. Total: ", str(len(folder_mf_dict)))
    folder_ds_dict = build_folder_dict(root_ds); print("Got all DS folders. Total: ", str(len(folder_ds_dict)))
    folder_ds_handled = []
    folderTot = len(folder_mf_dict) 
    folderCur = 0
    foldder_ds_to_handle = 0
    print('Phase 1 - MF + DS Folders')
    for folder_name in folder_mf_dict.keys():
        folder_mf = folder_mf_dict.get(folder_name)
        folder_ds = folder_ds_dict.get(folder_name)
        folder_ds_handled.append(folder_name)
        handle_folder_pair(folder_mf,folder_ds, req_condition_list)
        if folder_ds is None:
            foldder_ds_to_handle +=1         
        folderCur += 1
        foldperc = folderCur / folderTot        
        msg = 'Folder '+str(folderCur)+'/'+str(folderTot)+ ' ({:.2%})                     '        
        print(msg.format(foldperc), end='\r')        
    print('Phase 2 - Remaining DS Folders           ')
    folderTot = len(folder_ds_dict) + foldder_ds_to_handle - len (folder_ds_handled) 
    folderCur = 0
    for folder_name in folder_ds_dict.keys():
        if folder_name not in folder_ds_handled:
            folder_ds = folder_ds_dict.get(folder_name)
            handle_folder_pair(None,folder_ds, req_condition_list)
            folderCur += 1
            foldperc = folderCur / folderTot
            msg = 'Folder '+str(folderCur)+'/'+str(folderTot)+ ' ({:.2%})                     '
            print(msg.format(foldperc), end='\r')
    print('Phase 3 - Cleanup of folder conditions          ')
    del_folder_out_cond(folder_mf_dict)
    del_folder_out_cond(folder_ds_dict)
    return

def get_req_condition_list(root, req_condition_list):
    for folder in root.iter('SMART_FOLDER'):
        get_folder_req_condition_list(folder, req_condition_list)
    for folder in root.iter('FOLDER'):
        get_folder_req_condition_list(folder, req_condition_list)
    return req_condition_list

def get_folder_req_condition_list(folder, req_condition_list):
    for job in folder.iter('JOB'):
        # print ("job {} condition scanning".format(job.attrib['JOBNAME'])) for DS jobs only
        for out_cond in job.iter('OUTCOND'):
            out_cond_name:str = out_cond.attrib['NAME']
            if out_cond.attrib['SIGN'] == 'DEL' or out_cond.attrib['SIGN'] == '-':
                req_condition_list.append(out_cond_name)
                # print ("condition {} will be skipped".format(out_cond_name))
        for in_cond in job.iter('INCOND'):
            in_cond_name:str = in_cond.attrib['NAME']
            if in_cond_name.startswith('SUSPEND_') or \
                    in_cond_name.startswith('JCL_OVERIDE_') or \
                    in_cond_name.startswith('VERIFY_JCL_') or \
                    in_cond_name.startswith('HELD_') or \
                    in_cond_name.startswith('NW_') or \
                    in_cond_name.startswith('DSN_TRIG_'):
                req_condition_list.append(in_cond_name)
    return

def build_folder_dict(root):
    folder_dict = {}
    for folder in root.iter('SMART_FOLDER'):
        folder_dict[folder.attrib['FOLDER_NAME']] = folder
    for folder in root.iter('FOLDER'):
        folder_dict[folder.attrib['FOLDER_NAME']] = folder
    return folder_dict

def del_folder_out_cond(folder_dict):
    for folder_name in folder_dict.keys():
        folder = folder_dict.get(folder_name)
        element_to_be_removed = True
        while element_to_be_removed:
            element_to_be_removed = False
            for element in folder:
                if (element.tag.find('OUTCOND') >= 0):
                    if (element.attrib['SIGN'].find('DEL') >= 0 or element.attrib['SIGN'].find('-') >= 0) and element.attrib['NAME'].startswith(folder_name + '_'):
                        folder.remove(element)
                        element_to_be_removed = True
    return
def handle_folder_pair(folder_mf,folder_ds, req_condition_list):
    if (folder_ds != None and folder_mf != None):
        folder_name = folder_mf.attrib['FOLDER_NAME']
        # print ("folder both MF and DS {}".format(folder_name))
    elif (folder_mf != None):
        folder_name = folder_mf.attrib['FOLDER_NAME']
        # print ("folder only in MF {}".format(folder_name))
    else:
        folder_name = folder_ds.attrib['FOLDER_NAME']
        # print ("folder only in DS {}".format(folder_name))
    #conditions_names = []
    conditions_names = set()
    dict_of_all_ok_out_cond = get_dict_of_all_ok_out_cond(folder_mf, req_condition_list)
    dict_of_all_ok_out_cond.update(get_dict_of_all_ok_out_cond(folder_ds, req_condition_list))
    # if len(dict_of_all_ok_out_cond) > 0:
    #     print ("folder {} has {} OK COND".format(folder_name, str(len(dict_of_all_ok_out_cond))))
    not_in_use = 0
    single_use = 0
    multiple_use = 0
    dict_job_list_of_cond:dict = {}
    for cond_name_sched_id in dict_of_all_ok_out_cond.keys():
        list_of_all_jobs_that_have_it_as_in_cond = \
        get_list_of_all_jobs_that_have_it_as_in_cond(folder_mf, cond_name_sched_id) + get_list_of_all_jobs_that_have_it_as_in_cond(folder_ds, cond_name_sched_id)
        dict_job_list_of_cond[cond_name_sched_id] = list_of_all_jobs_that_have_it_as_in_cond
    for cond_name_sched_id in dict_of_all_ok_out_cond.keys():
        job_cond_as_out = dict_of_all_ok_out_cond.get(cond_name_sched_id)
        list_of_all_jobs_that_have_it_as_in_cond = dict_job_list_of_cond.get(cond_name_sched_id)
        if (sched_id_sep in cond_name_sched_id):
            cond_name, sched_id = cond_name_sched_id.split(sched_id_sep)
        else:
            cond_name = cond_name_sched_id
            sched_id = ""
        if len(list_of_all_jobs_that_have_it_as_in_cond) == 0:
            ###print ("folder {} has {}/{} OK COND that is not in use".format(folder_name, cond_name, sched_id))
            logger.info("folder {} has {}/{} OK COND that is not in use".format(folder_name, cond_name, sched_id))
            delete_out_cond(job_cond_as_out, cond_name)
            not_in_use += 1
        elif len(list_of_all_jobs_that_have_it_as_in_cond) == 1:
            job_cond_as_in = list_of_all_jobs_that_have_it_as_in_cond[0]
            new_cond_name = get_new_cond_name(cond_name, sched_id, job_cond_as_in, job_cond_as_out, conditions_names)
            rename_in_cond_and_del(job_cond_as_in, cond_name, new_cond_name)
            rename_out_cond(job_cond_as_out, cond_name, new_cond_name)
            single_use += 1
            ###print ("folder {} has {}/{} OK COND - single use".format(folder_name, cond_name, sched_id))
            logger.info("folder {} has {}/{} OK COND - single use".format(folder_name, cond_name, sched_id))
        else:
            for job_cond_as_in in list_of_all_jobs_that_have_it_as_in_cond:
                new_cond_name = get_new_cond_name(cond_name, sched_id, job_cond_as_in, job_cond_as_out, conditions_names)
                rename_in_cond_and_del(job_cond_as_in, cond_name, new_cond_name)
                add_out_cond_like_existing(job_cond_as_out, cond_name, new_cond_name)
                delete_out_cond(job_cond_as_out, cond_name)

            multiple_use += 1
            ###print ("folder {} has {}/{} OK COND - multiple uses".format(folder_name, cond_name, sched_id))
            logger.info("folder {} has {}/{} OK COND - multiple uses".format(folder_name, cond_name, sched_id))
            # print ("folder {} has {} OK COND".format(folder_name, str(len(dict_of_all_ok_out_cond))))
    or_in_cond_if_from_same_job(folder_mf,folder_ds)
    ###print ("Folder {}, has {} One Direction COND, {} not used and will be deleted, {} single use, {} multiple usage".format(\
    logger.info("Folder {}, has {} One Direction COND, {} not used and will be deleted, {} single use, {} multiple usage".format(\
        folder_name, str(len(dict_of_all_ok_out_cond)), str(not_in_use), str(single_use), str(multiple_use)))
    return

def or_in_cond_if_from_same_job(folder_mf,folder_ds):
    if (folder_ds != None):
        for job in folder_ds.iter('JOB'):
            or_job_in_cond_if_from_same_job(job)
    if (folder_mf != None):
        for job in folder_mf.iter('JOB'):
            or_job_in_cond_if_from_same_job(job)
    return

def or_job_in_cond_if_from_same_job(job):
    # list_of_all_in_cond_prefixes = [] 
    # list_of_multi_prefixes = [] 
    list_of_all_in_cond_prefixes = set() 
    list_of_multi_prefixes = set()
    for cond in job.iter('INCOND'):
        cond_name = cond.attrib['NAME']
        if sched_id_sep in cond_name:
            prefix_cond_name = cond_name[0:cond_name.index(sched_id_sep)]
            if prefix_cond_name in list_of_all_in_cond_prefixes:
                if prefix_cond_name not in list_of_multi_prefixes:
                    # list_of_multi_prefixes.append(prefix_cond_name) 
                    list_of_multi_prefixes.add(prefix_cond_name)
            else:
                #list_of_all_in_cond_prefixes.append(prefix_cond_name)
                list_of_all_in_cond_prefixes.add(prefix_cond_name)
    if len(list_of_multi_prefixes) > 1:
        logger.info('Job {} have more than single set of multiple in conditions {}. Must be manually adjusted'.format(get_jobname(job), " ".join(list_of_multi_prefixes) ) )
        ###print ('Job {} have more than single set of multiple in conditions {}. Must be manually adjusted'.format(get_jobname(job), " ".join(list_of_multi_prefixes) ) )
    for cond_name_prefix in sorted(list_of_multi_prefixes):
        for cond in job.iter('INCOND'):
            if cond.attrib['NAME'].startswith(cond_name_prefix):
                cond.attrib['AND_OR'] = 'O'
                # print('Job {} in cond {} relation changed to OR'.format(get_jobname(job),cond.attrib['NAME'] ))
    return

def get_new_cond_name(cond_name, sched_id, job_cond_as_in, job_cond_as_out, conditions_names):
    try:
        target_folder_name = job_cond_as_out.attrib['GROUP']
    except KeyError:
        target_folder_name = job_cond_as_out.attrib['PARENT_FOLDER']
    try:
        source_folder_name = job_cond_as_in.attrib['GROUP']
    except KeyError:
        source_folder_name = job_cond_as_in.attrib['PARENT_FOLDER']
    try:
        target_job_name = job_cond_as_in.attrib['JOBNAME']
    except KeyError:
        target_job_name = job_cond_as_in.attrib['MEMNAME']
    if sched_id == "": 
        sched_id_with_sep = ""
    else:
        sched_id_with_sep = sched_id_sep + sched_id
        
    if (condition_format == 'l'):
        new_cond_name = cond_name.replace(ok_suffix, "-" + target_folder_name + "_" + target_job_name + sched_id_with_sep)
    elif (condition_format == 'u'):
        new_cond_name = cond_name.replace(ok_suffix, "-" + target_job_name + sched_id_with_sep + ok_suffix)
    else:
        new_cond_name = cond_name.replace(ok_suffix, "-" + target_job_name + sched_id_with_sep + ok_suffix).replace(source_folder_name + "_", "", 1)
        # print ("old name {} new name {}".format(cond_name, new_cond_name))
    if (new_cond_name in conditions_names) or (new_cond_name == cond_name):
        ###print ("{} alaready generated".format(new_cond_name))
        logger.info("{} already generated".format(new_cond_name))
        matches = re.finditer(r"\S*_(\d\d)", new_cond_name)
        for match_num, match in enumerate(matches, start=1):
            # print ("Matchs {}".format(match_num))
            current_counter = match.group(1)
            # print ("group {}".format(current_counter))
            for dup_counter in range(int(current_counter)+1, 99 ):
                counter_suffix = "_" + str(dup_counter).zfill(2)
                new_cond_name_with_suffix = new_cond_name.replace("_" + current_counter, counter_suffix)
                if new_cond_name_with_suffix not in conditions_names:
                    new_cond_name = new_cond_name_with_suffix
                    ###print ("replaced by {}".format(new_cond_name))
                    logger.info("replaced by {}".format(new_cond_name))
                    break

    if (new_cond_name in conditions_names) or (new_cond_name == cond_name): 
        for dup_counter in range(1,99):
            counter_suffix = "_" + str(dup_counter).zfill(2)
            new_cond_name_with_suffix = new_cond_name + counter_suffix
            if new_cond_name_with_suffix not in conditions_names:
                new_cond_name = new_cond_name_with_suffix
                ###print ("replaced by {}".format(new_cond_name))
                logger.info("replaced by {}".format(new_cond_name))
                break

    #conditions_names.append(new_cond_name)
    conditions_names.add(new_cond_name)

    return new_cond_name

def get_dict_of_all_ok_out_cond(folder, req_condition_list):
    dict_of_out_cond:dict = {}
    if folder is not None:
        # folder_name = folder.attrib['FOLDER_NAME']
        for job in folder.iter('JOB'):
            # job_name = get_jobname(job)
            for out_cond in job.iter('OUTCOND'):
                out_cond_name:str = out_cond.attrib['NAME']
                exist_count = req_condition_list.count(out_cond_name)
                if exist_count > 0:
                    pass
                    # print ("condition {} skipped".format(out_cond_name))
                else:
                    if out_cond.attrib['SIGN'] == 'ADD' or out_cond.attrib['SIGN'] == '+':
                        sched_id_list = get_job_chg_schid(job)
                        if len(sched_id_list) == 0:
                            sched_id_list = get_sched_id(folder, job)
                        
                        if len(sched_id_list) > 0:
                            for sched_id in sched_id_list:
                                dict_of_out_cond[out_cond_name + sched_id_sep + sched_id] = job
                        else:
                            dict_of_out_cond[out_cond_name] = job
                    # if out_cond_name.startswith('DSN_TRIG'):
                    #     dict_of_out_cond[out_cond_name] = job
    return dict_of_out_cond

def get_job_chg_schid(job):
    sched_id_list = []
    for var in job.iter('VARIABLE'):
        if var.attrib['NAME'] == '%%CHG_SCHID':
            sched_id_list.append(var.attrib['VALUE'])
    return sched_id_list

def get_jobname(job):
    try:
        job_name = job.attrib['JOBNAME']
    except KeyError:
        job_name = job.attrib['MEMNAME']
    return job_name

def get_sched_id(folder, job):
    sched_id_list = []
    for rbc in job.iter('RULE_BASED_CALENDARS'):
        rbc_name = rbc.attrib['NAME']
        if rbc_name == '*':
            get_folder_sched_id(folder, sched_id_list)
        if len(rbc_name) > 3:
            sched_id_list.append(rbc_name[0:3])
    return sched_id_list
    
def get_folder_sched_id(folder, sched_id_list):
    for rbc in folder.iter('RULE_BASED_CALENDAR'):
        rbc_name = rbc.attrib['NAME']
        sched_id_list.append(rbc_name[0:3])
    return


def get_list_of_all_jobs_that_have_it_as_in_cond(folder, cond_name_sched_id):
    job_list = [] 
    if (sched_id_sep in cond_name_sched_id):
        cond_name, cond_sched_id = cond_name_sched_id.split(sched_id_sep)
        if folder is not None:
            for job in folder.iter('JOB'):
                for in_cond in job.iter('INCOND'):
                    if in_cond.attrib['NAME'] == cond_name:
                        sched_id_list = get_sched_id(folder, job)
                        for sched_id in sched_id_list:
                            if sched_id == cond_sched_id:
                                job_list.append(job) 
    else:
        cond_name = cond_name_sched_id
        if folder is not None:
            for job in folder.iter('JOB'):
                for in_cond in job.iter('INCOND'):
                    if in_cond.attrib['NAME'] == cond_name:
                        job_list.append(job)
    return job_list

def rename_in_cond_and_del(job, cond_name, new_cond_name):
    in_cond_found = False
    cond_to_add = [] # andrea
    last_cond = None # andrea
    for cond in job.iter('INCOND'):
        #in_cond_to_insert = copy.deepcopy(cond)  andrea
        last_cond = cond # andrea
        if cond.attrib['NAME'] == cond_name:
            cond.attrib['NAME'] = new_cond_name
            #out_cond_to_insert = copy.deepcopy(cond) andrea
            out_cond_to_insert = ET.fromstring(ET.tostring(cond))  #andrea
            out_cond_to_insert.tag = 'OUTCOND'
            out_cond_to_insert.attrib['SIGN'] = '-'
            out_cond_to_insert.attrib['ODATE'] = remove_date
            out_cond_to_insert.attrib['NAME'] = new_cond_name
            del out_cond_to_insert.attrib['AND_OR']
            try:
                del out_cond_to_insert.attrib['OP']
            except KeyError:
                pass
            #job.append(out_cond_to_insert) andrea
            cond_to_add.append(out_cond_to_insert) 
            in_cond_found = True
    if not in_cond_found:
        # print ('in-cond {} must be added. job {}'.format(new_cond_name,job.attrib['MEMNAME']))
        in_cond_to_insert = ET.fromstring(ET.tostring(last_cond)) #andrea        
        in_cond_to_insert.attrib['NAME'] = new_cond_name
        job.append(in_cond_to_insert)
        # out_cond_to_insert = copy.deepcopy(in_cond_to_insert)
        out_cond_to_insert = ET.fromstring(ET.tostring(in_cond_to_insert))  #andrea
        out_cond_to_insert.tag = 'OUTCOND'
        out_cond_to_insert.attrib['SIGN'] = '-'
        out_cond_to_insert.attrib['ODATE'] = remove_date
        out_cond_to_insert.attrib['NAME'] = new_cond_name
        del out_cond_to_insert.attrib['AND_OR']
        try:
            del out_cond_to_insert.attrib['OP']
        except KeyError:
            pass
        #job.append(out_cond_to_insert) andrea
        cond_to_add.append(out_cond_to_insert) #andrea
    for cond in cond_to_add: #andrea
        job.append(cond) #andrea
    return
def rename_out_cond(job, cond_name, new_cond_name):
    out_cond_found = False
    for cond in job.iter('OUTCOND'):
        out_cond_to_insert = copy.deepcopy(cond)
        if cond.attrib['NAME'] == cond_name:
            cond.attrib['NAME'] = new_cond_name
            out_cond_found = True
    if not out_cond_found:
        # print ('out-cond {} to be added. job {}'.format(new_cond_name, job.attrib['MEMNAME']))
        out_cond_to_insert = ET.Element('OUTCOND')
        out_cond_to_insert.attrib['NAME'] = new_cond_name
        out_cond_to_insert.attrib['SIGN'] = '+'
        out_cond_to_insert.attrib['ODATE'] = 'ODAT'
        job.append(out_cond_to_insert)

    return
def add_out_cond_like_existing(job, cond_name, new_cond_name):
    out_cond_found = False
    conds_to_add = []
    for cond in job.iter('OUTCOND'):
        # out_cond_to_insert = copy.deepcopy(cond)
        if cond.attrib['NAME'] == cond_name:
            out_cond_to_insert = copy.deepcopy(cond)
            out_cond_to_insert.attrib['NAME'] = new_cond_name
            if out_cond_to_insert not in conds_to_add:
                conds_to_add.append(out_cond_to_insert)
            #job.append(out_cond_to_insert)
            out_cond_found = True
    if not out_cond_found:
        ###print ('out-cond {} to be add like not found. job {}'.format(new_cond_name, get_jobname(job)))
        logger.info("folder {} has {} OK COND - multiple uses".format(new_cond_name, get_jobname(job)))
        out_cond_to_insert = ET.Element('OUTCOND')
        out_cond_to_insert.attrib['NAME'] = new_cond_name
        out_cond_to_insert.attrib['SIGN'] = '+'
        out_cond_to_insert.attrib['ODATE'] = 'ODAT'
        job.append(out_cond_to_insert)
        # out_cond_to_insert.attrib['NAME'] = new_cond_name
        # job.append(out_cond_to_insert)
    else:
        for cond in conds_to_add:
            job.append(cond)
    return
def delete_out_cond(job, cond_name):
    conds_to_delete = []
    for cond in job.iter('OUTCOND'):
        if cond.attrib['NAME'] == cond_name:
            # print ('condition {} deleted'.format(cond_name))
            # job.remove(cond)
            if cond not in conds_to_delete:
                conds_to_delete.append(cond)
    
    if len(conds_to_delete) > 0: 
        for cond in conds_to_delete:
            job.remove(cond)    
        return

start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")