@ECHO off
setlocal enabledelayedexpansion
REM set default values for the arguments

SET username=
SET password=
SET server=
SET database=
SET tables_list=JOBDTL,NODMST,NODLSTDT,OWNER,USRMST,RESMST,VARMST,TRGMST,TRGJOB,EVNTMST,EVNTCHLD,EVNTCOND,EVNTYEAR,EVNTFSCL,WORKUSR,WORKGRP,JOBCLS,RESJOB,JOBMST,JOBDEP,NODLSTMS,TRGTSK,TSKALRT,TSKLOG,TSKMAIL,TSKMST,TSKSCH,TSKVAR,SERVICEMST,BIZUNIT
SET use_windows_credentials=0
SET pattern=-

:loop_argument
IF NOT "%1"=="" (
	IF "%1"=="-U" (
        SET username=%2
        SHIFT
    )
    IF "%1"=="-P" (
        SET password=%2
        SHIFT
    )
	IF "%1"=="-S" (
        SET server=%2
        SHIFT
    )
	IF "%1"=="-D" (
        SET database=%2
        SHIFT
    )
	IF "%1"=="-T" (
        SET in_tables_list=1
		SET tables_list=
    )
	
	IF "%1"=="-W" (
        SET use_windows_credentials=1
    )
	
	ECHO.%1 | findstr /C:"%pattern%" 1>NUL
	IF errorlevel 1 IF !in_tables_list!==1 (
	  SET tables_list=!tables_list!,%1
	)
	
    SHIFT
	GOTO :loop_argument
)

set MISSING_ARGUMENT=
IF %use_windows_credentials%==0 (
	IF NOT DEFINED username SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<username^>
	IF NOT DEFINED password SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<password^>
) 
IF NOT DEFINED server SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<database server^>
IF NOT DEFINED database SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<database/schema name^>

IF DEFINED MISSING_ARGUMENT GOTO USAGE

REM initialize parameters
SET data_directory_name=Data
SET log_name=log.log
SET header_file_name=HeadersOnly.csv
SET data_file_name=TableDataWithoutHeaders.csv
SET final_data_file_suffix=.csv

REM Check for bcp utility to exist on execution host
bcp -v 2>&1 >> %log_name%
IF errorlevel 1 (
	ECHO.
	ECHO Unable to locate the MSSQL client, specifically the "bcp" utility, please verify this is executed on a machine with a MSSQL client installed!
	exit /b 2
)

MKDIR %data_directory_name% 2>&1 >> %log_name%
IF errorlevel 1 (
	ECHO.
	ECHO Directory "Data" already exist, any file exists in "Data" directory might be overwritten.
	CHOICE /M  "Would you like to continue, "
	IF errorlevel 2 (
		EXIT /b 0
	)
)

SET failed=0
SET bcp_credentials=-U%username% -P%password%
SET sqlcmd_credentials=-U%username% -P%password%
IF %use_windows_credentials%==1 (
	ECHO USING WINDOWS CREDENTIALS...
	SET bcp_credentials=-T
	SET sqlcmd_credentials=-E
)
FOR %%a IN (%tables_list%) DO (
	ECHO. 
	ECHO Exporting %%a ...
	SET failed=0
    
	BCP "DECLARE @colnames VARCHAR(max);SELECT @colnames = COALESCE(@colnames + ',', '') + column_name from %database%.INFORMATION_SCHEMA.COLUMNS where TABLE_NAME='%%a'; select @colnames;" queryout %header_file_name% -c -S%server% %bcp_credentials% 2>&1 >> %log_name%
	sqlcmd -S %server% %sqlcmd_credentials% -d %database% -Q "SET NOCOUNT ON; DECLARE @template AS varchar(max); SET @template = 'SELECT {COLUMN_LIST} FROM %database%.dbo.%%a'; DECLARE @column_list AS varchar(max); SELECT @column_list = COALESCE(@column_list + ',', '') + '''""'' + CASE WHEN ISDATE(RTRIM(LTRIM(ISNULL(CAST(' + column_name + ' AS varchar(4000)),''''))))=1 THEN convert(varchar, ' + column_name + ', 121) ELSE REPLACE(RTRIM(LTRIM(ISNULL(CAST(' + column_name + ' AS varchar(MAX)),''''))), ''""'', ''""""'') END + ''""''' FROM %database%.INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '%%a'; SET @template = REPLACE(@template, '{COLUMN_LIST}', @column_list); EXEC (@template);" -s "," -y0 -o %data_file_name% 2>&1 >> %log_name%

	COPY /b %header_file_name%+%data_file_name% %data_directory_name%\%%a%final_data_file_suffix% 2>&1 >> %log_name%
	
	IF NOT EXIST %header_file_name% (
		ECHO Failed to export %%a headers.
		SET failed=1
	) ELSE (
		DEL %header_file_name% 2>&1 >> %log_name%
	)
	
	IF NOT EXIST %data_file_name% (
		ECHO Failed to export %%a data.
		SET failed=1
	) ELSE (
		DEL %data_file_name% 2>&1 >> %log_name%
	)
	
	IF !failed!==1 IF EXIST %data_directory_name%\%%a%final_data_file_suffix% (
		DEL %data_directory_name%\%%a%final_data_file_suffix% 2>&1 >> %log_name%
	)
)

EXIT /b %failed%

:USAGE
SET tab=	
ECHO.
ECHO This script requires a MSSQL client installed including the bcp utility.
ECHO usage:%tab%Tidal_MsSQL_export (-U ^<username^> -P ^<password^> ^| -W to use windows credentials) -S ^<database server^> -D ^<database/schema name^>
ECHO.
ECHO log file (named "log.log") containing BCP / SQLCMD warning/error messages and the scripts messages is created next to the script
