use warnings;
use strict;

if (@ARGV != 2) {
  print "\nUsage: aaa <Old version file location> <New version file location>\n";
  exit 1;
}

(my $oldVersionFileName, my $newVersionFileName) = @ARGV;

open(my $oldVersionFile, "<", $oldVersionFileName) or die "Can't open old version file: $!";
open(my $newVersionFile, "<", $newVersionFileName) or die "Can't open new version file: $!";

my $oldVersion = <$oldVersionFile>;
my $newVersion = <$newVersionFile>;

close($oldVersionFile);
close($newVersionFile);

my @oldVersionArray;
if ($oldVersion =~ m/version=(.*)/)
{
	$oldVersion = $1;
	@oldVersionArray = split(/\./, $oldVersion);
}

my @newVersionArray;
if ($newVersion =~ m/version=(.*)/)
{
	$newVersion = $1;
	@newVersionArray = split(/\./, $newVersion);
}

my $retVal = 1;
if (@oldVersionArray < @newVersionArray)
{
	$retVal = 0;
}

while ( defined (my $old = shift(@oldVersionArray)) and defined (my $new = shift(@newVersionArray)))
{
	if ($old < $new)
	{
		$retVal = 0;
		last;
	}
	elsif ($old > $new)
	{
		$retVal = 1;
		last;
	}
}

print $retVal;

exit $retVal;
