spool NodeMapping.txt

set heading off
set pagesize 49999
set linesize 100
set termout off
set serveroutput on
set feedback off

column so_oper_name format a30;
column so_ip_address format a40;
column so_op_sys format a10;
column so_time_zone format a3;
column so_master_flag format a3;
column so_mach_factor format a3;

select so_oper_name, so_ip_address, so_op_sys,so_time_zone,so_master_flag,so_mach_factor from so_operators;

declare

cursor cur1 is select so_oper_grp,so_multi_execute from so_oper_group;
cursor cur2(group_name varchar2) is
                                    select so_oper_grp,
                                           so_oper_name
                                    from   aw_agent_group_detail,
                                           so_oper_group,
                                           so_operators
                                    where  aw_agentgrp_seq = so_opgrp_seq(+)
                                    and    aw_agent_seq    = so_oper_seq(+)
                                    and    so_oper_grp = group_name
                                    order  by 1, 2;


v_so_oper_grp varchar(40);
v_so_multi_execute varchar(40);
v_so_oper_name varchar(40);

begin

   open cur1;

   loop

       fetch cur1 into v_so_oper_grp,v_so_multi_execute;
       exit when cur1%NOTFOUND;

       dbms_output.put_line('  Group: ' || v_so_oper_grp || '          Multi Host Execution: ' || v_so_multi_execute);

       open cur2(v_so_oper_grp);
	   
       loop

          fetch cur2 into v_so_oper_grp,v_so_oper_name;
          exit when cur2%NOTFOUND;

          dbms_output.put_line(v_so_oper_name);


       end loop;
       close cur2;

   end loop;

   close cur1;

end;
/
exit
