@echo off

SET CURRENT_DIR=%CD%
SET BATCH_DIR=%~dp0

SETLOCAL

CD %BATCH_DIR%lib\Infrastructure

set conversion_jar_file="%CD%\Infrastructure-GUI-ctmconvert.jar"
IF NOT EXIST %conversion_jar_file% (
    echo.
    echo The file %conversion_jar_file% was not found
    echo.
 )
IF "%RUN_MY_JAVA%"=="" GOTO CONVERSION_JAVA
IF %RUN_MY_JAVA% NEQ RUN_MY_JAVA goto CONVERSION_JAVA

java -version >NUL 2>&1
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA

java -version 2>&1 | findstr /r "2[1-9]\.[0-9]*" >NUL
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA
::echo RUN_MY_JAVA = %RUN_MY_JAVA%
START "Conversion" javaw.exe -jar -Djco.trace_path=logs %conversion_jar_file%
goto EXIT

:CONVERSION_JAVA
::echo 64-bit...
START "Conversion" "%BATCH_DIR%JRE\jre_64\bin\javaw.exe" -Xmx30G -jar -Djco.trace_path=logs %conversion_jar_file%
GOTO EXIT

:EXIT
ENDLOCAL
SET RC=%errorLevel%
CD %CURRENT_DIR%
echo.
exit /B %RC%

:NO_JAVA
  echo.
  echo This utility requires Java Runtime Environment version 1.8 or higher.
  echo Make sure Java is installed and configured before reruning the utility.
  echo.
  pause
  goto EXIT
