$current_value = ctm config systemsettings:server::get | Select-String -Pattern "ENABLE_AGENT_UTIL" -Context 0,1 | `
    ForEach-Object { $_.Context.PostContext } | `
    Select-String -Pattern 'value' | `
    ForEach-Object { ($_ -split '"')[3] }

if ($current_value -ne "Y") {
    Write-Host "Updating ENABLE_AGENT_UTIL to 'Y'..."
    ctm config systemsettings:server::set ENABLE_AGENT_UTIL Y
    if ($LASTEXITCODE -eq 0) {
        Write-Host "Successfully updated ENABLE_AGENT_UTIL to 'Y'."
    } else {
        Write-Error "Failed to update ENABLE_AGENT_UTIL."
        exit 1
    }
    #waiting for synchronization of systemsettings value
    Start-Sleep -Seconds 30
} else {
    Write-Host "ENABLE_AGENT_UTIL is already set to '$current_value'. No update needed."
}

Write-Host "Adding variables..."

<CTMVAR_COMMANDS>

Write-Host "All variables added."

if ($current_value -ne "Y") {
    Write-Host "Updating ENABLE_AGENT_UTIL to 'N'..."
    ctm config systemsettings:server::set ENABLE_AGENT_UTIL N
    if ($LASTEXITCODE -eq 0) {
        Write-Host "Successfully updated ENABLE_AGENT_UTIL to 'N'."
    } else {
        Write-Error "Failed to update ENABLE_AGENT_UTIL."
        exit 1
    }
}