/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.IWorkspaceData;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSkeletonParser
implements IWorkspaceData {
    private XmlElement jobSkeleton;
    private XmlElement folderSkeleton;
    private String headerName = "DEFTABLE";
    private XmlElement rootElement;

    public void parse(InputStream skeletonInputStream) throws BridgeException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(skeletonInputStream);
            doc.getDocumentElement().normalize();
            this.rootElement = new XmlElement((Element)doc.getElementsByTagName("DEFTABLE").item(0));
            this.folderSkeleton = new XmlElement((Element)doc.getElementsByTagName(SchedEntity.TYPE.SMART_FOLDER.name()).item(0));
            this.jobSkeleton = new XmlElement((Element)doc.getElementsByTagName(SchedEntity.TYPE.JOB.name()).item(0));
            try {
                this.folderSkeleton.removeChild(this.jobSkeleton);
            }
            catch (DOMException dOMException) {}
        }
        catch (Exception e) {
            Logger.getLogger().writeToLog(e);
            throw new BridgeException("The CTM data template that specified has an invalid structure");
        }
    }

    public XmlElement getJobSkeleton() {
        return this.jobSkeleton;
    }

    public XmlElement getFolderSkeleton() {
        return this.folderSkeleton;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Map<String, String> getHeaderAttributes() {
        return this.rootElement.getAttributes();
    }

    public XmlElement getRootElement() {
        return this.rootElement;
    }
}

